<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('seo_page_title', config('app.name'))</title>
    <meta name="description" content="@yield('seo_meta_description')">
    
    <!-- Styles -->
    <link href="{{ mix('css/vendor.css') }}" rel="stylesheet">
    <link href="{{ mix('css/app.css') }}" rel="stylesheet">
    <!-- Scripts -->
    <script>
        window.Laravel = {!! json_encode([
            'csrfToken' => csrf_token(),
        ]) !!}
    </script>
</head>
<body>
    @include('shared.menu')
    @include('frontend.banners.index')

    <div class="container-fluid">
        @yield('content')
    </div>
    <br><br><br><br><br><br><br><br><br><br>
    <!-- Scripts -->
    <script src="{{ mix('js/app.js') }}"></script>
    <script type="text/javascript">
        @yield ('scripts')
    </script>
    <script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDggBkfWgQyh-RlviwD7JPA8C6OXF_F3cw"> </script>
    @include('shared.modals')

</body>
</html>
