{!! Form::open(['route' => ['home'], 'class' => 'navbar-form navbar-search', 'role' => 'search', 'method' => 'GET']) !!}
<div class="input-group">
    <div class="input-group-btn">
        <button type="button" class="btn btn-search btn-default dropdown-toggle" data-toggle="dropdown">
            <span class="label-icon">Rechercher parmi {{ $products_count = number_format(\App\Models\Product::count(), 0, ',', ' ') }} produits</span>
            <span class="caret"></span>
        </button>
        <ul class="dropdown-menu pull-left" role="menu">
            <li>
                <a href="#" data-type="products" data-action="{{ route('home') }}">
                    <span class="label-icon">Rechercher parmi {{ $products_count }} produits</span>
                    <span class="caret"></span>
                </a>
            </li>
            <li>
                <a href="#" data-type="catalogues" data-action="{{ route('catalogues.index') }}">
                    <span class="label-icon">Rechercher parmi {{ number_format(\App\Models\Catalogue::count(), 0, ',', ' ') }} catalogues</span>
                    <span class="caret"></span>
                </a>
            </li>
            <li>
                <a href="#" data-type="projects" data-action="{{ route('projects.index') }}">
                    <span class="label-icon">Rechercher parmi {{ number_format(\App\Models\Project::count(), 0, ',', ' ') }} projets</span>
                    <span class="caret"></span>
                </a>
            </li>
            <li>
                <a href="#" data-type="trends" data-action="{{ route('trends.index') }}">
                    <span class="label-icon">Rechercher parmi {{ number_format(\App\Models\Trend::count(), 0, ',', ' ') }} News & Trends</span>
                    <span class="caret"></span>
                </a>
            </li>
        </ul>
    </div>

    <input type="text" class="form-control search-input" name="q" id="menu-search-input" value="@if(isset($query)) {{ $query }} @endif">
    <div class="autofill-container">
        Lorem, ipsum dolor sit amet consectetur adipisicing elit. Ullam reiciendis aperiam doloremque! Voluptatem, perferendis molestias beatae itaque dolores ratione error, in, reiciendis quos nulla repudiandae optio sint iure mollitia dolorem!
    </div>
    @if(isset($type))
        <input type="hidden" name="query_type" id="query_type" value="{{ $type }}">
    @else
        <input type="hidden" name="type" id="query_type" value="products">
    @endif
    <div class="input-group-btn">
        <button type="submit" class="btn btn-search btn-default">
            <i class="fa fa-search" aria-hidden="true"></i>
        </button>
    </div>
</div>
{!! Form::close() !!}