<div class="col-md-4">
    <div class="media salon-item">
        <div class="media-left">
            <div class="salon-img">    
                <a href="@if($salon->link) {{ $salon->link }} @endif" target="_blank">
                @if(isset($salon->image) && !empty($salon->image))
                    <img src="{{ asset('storage/companies/'.$salon->company->id.'/salons/'.$salon->image) }}" class="media-object">
                @else
                    <img src="{{ asset('images/no-photo.jpg') }}" class="media-object">
                @endif  
                </a>
            </div>
          
        </div>
        <div class="media-body">
            <span class="media-heading">{{ $salon->name }}</span>
            <div>
                <i class="fa fa-calendar" aria-hidden="true"></i> Du {{ $salon->date_start->format('d/m/Y') }} au {{ $salon->date_end->format('d/m/Y') }}
            </div>
            <div>
                <i class="fa fa-address-card-o" aria-hidden="true"></i>
                {!! nl2br($salon->coordonnees) !!}
            </div>
            <div>
                <i class="fa fa-globe" aria-hidden="true"></i> {{ $salon->ville }} ({{ $salon->country->name_fr }})
            </div>
            @if($salon->link)
                <div>
                    <br>
                    <a href="{{ $salon->link }}" target="_blank"><i class="fa fa-info-circle" aria-hidden="true"></i> Plus d'informations</a>
                </div>
            @endif
            @if($salon->confirmed == 0)
                <div>
                    <span class="label label-default pull-right">Présence à confirmer</span>
                </div>
            @endif
        </div>
    </div>
</div>
