@extends('layouts.frontend')

@section('content')
    <ol class="breadcrumb">
        <li><a href="{{ route('home') }}">Produits</a></li>
        <li class="active">{{ $category->name }}</li>
    </ol>

    <div class="container" style="width: 970px;">
        <div class="row">
            <div class="col-md-12">
                <h1 class="page-header">{{ $category->name }}</h1>
            </div>
        </div>
        <div class="row" id="categories">

            <div class="col-lg-3 col-md-3 col-sm-3 col-xs-3">
                @php
                    $first = $categories->first();
                @endphp
                @if(isset($first->image) && !empty($first->image))
                    <img src="{{ asset('storage/categories/' . $first->image) }}" style="width: 350px" class="img-responsive" id="cat-image">
                @else
                    <img src="{{ asset('images/no-photo.jpg') }}" style="width: 350px;" class="img-responsive" id="cat-image">
                @endif
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                <ul id="categories-list">
                    @foreach($categories as $key => $category)
                        @php
                            if(isset($category->image) && !empty($category->image)) {
                                $imageUrl = asset('storage/categories/' . $category->image);
                            }else{
                                $imageUrl = asset('images/no-photo.jpg');
                            }
                        @endphp
                        <li>
                            <a href="{{ route('categories.produits', $category->slug) }}" data-image="{{ $imageUrl }}" class="category-link">{{ $category->name }}</a>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </div>

@endsection

@section('scripts')
$(function(){
    $('.category-link').hover(function(){
        var $image = $(this).data('image');
        $('#cat-image').attr('src', $image);
    });
})
@endsection