@extends('layouts.frontend')

@section('content')
    <ol class="breadcrumb">
        <li><a href="{{ route('catalogues.index') }}">Catalogues</a></li>
        <li><a href="{{ route('brands.catalogues.index', $catalogue->brand) }}">{{ $catalogue->brand->name }}</a></li>
        <li class="active">{{ $catalogue->name }}</li>
    </ol>

    @include('frontend.companies.menu', ['active' => 'catalogues'])

    <div class="row">

        <div class="col-md-10 col-md-offset-1">
            <h1 class="page-header">
                {{ $catalogue->name }}
            </h1>

        </div>
        <div class="col-md-10 col-md-offset-1">
            <div class="row">
                <div class="col-md-8">
                    <object data="{{ $catalogue->file_link }}#page=1" type="application/pdf" width="100%" height="600px">
                        <iframe src="{{ $catalogue->file_link }}#page=1" width="100%" height="100%" style="border: none;">
                            Ce navigateur ne prend pas en charge les fichiers PDF. Téléchargez le PDF pour le visualiser : <a href="{{ $catalogue->file_link }}">Télécharger le fichier PDF</a>
                        </iframe>
                    </object>
                </div>
                <div class="col-md-4">
                    <a href="{{ route('demandes.catalogues.index', $catalogue) }}" data-toggle="modal" data-target="#modal-lg" class="btn btn-default btn-lg btn-block">
                        <i class="fa fa-calculator pull-left" aria-hidden="true"></i> Tarfis/Devis
                    </a>
                    <a href="{{ route('demandes.catalogues.index', $catalogue) }}" data-toggle="modal" data-target="#modal-lg" class="btn btn-default btn-lg btn-block">
                        <i class="fa fa-question pull-left" aria-hidden="true"></i> Question
                    </a>
                    <a href="{{ route('demandes.catalogues.index', $catalogue) }}" data-toggle="modal" data-target="#modal-lg" class="btn btn-default btn-lg btn-block">
                        <i class="fa fa-book pull-left" aria-hidden="true"></i> Documentation
                    </a>
                    <a href="{{ route('companies.places', $brand) }}" data-toggle="modal" data-target="#modal-xlg" class="btn btn-default btn-lg btn-block">
                        <i class="fa fa-map-marker pull-left" aria-hidden="true"></i> Ou Acheter
                    </a>

                    <a href="#" class="btn btn-default btn-lg btn-block">
                        <i class="fa fa-star pull-left" aria-hidden="true"></i> Favoris
                    </a>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <br><br>
                    <h3 class="page-header">Tous les catalogues et brochures techniques {{ $brand->name }}</h3>
                </div>
            </div>
            <div class="row">
                @foreach($brand_catalogues as $catalogue)
                    @include('frontend.catalogues._catalogue')
                @endforeach
            </div>

            <div class="row">
                <div class="col-md-12">
                    <br><br>
                    <h3 class="page-header">Catalogues archivés</h3>
                </div>
            </div>
            <div class="row">
                @foreach($brand_catalogues_archived as $catalogue)
                    @include('frontend.catalogues._catalogue')
                @endforeach
            </div>

        </div>
    </div>




@endsection