@extends('layouts.frontend')

@section('content')
    <ol class="breadcrumb">
        <li><a href="{{ route('home') }}">Produits</a></li>
        <li class="active">{{ $brand->name }}</li>
    </ol>

    @include('frontend.companies.menu', ['active' => 'produits'])

    <div class="row">
        <div class="col-md-12">
            <h1 class="page-header">Tous les produits {{ $brand->name }}</h1>
        </div>
    </div>
    <div class="row">
        @foreach($brand->categories() as $category)
            <div class="col-md-12">
                <h3 class="page-header">{{ $category->name }}</h3>
            </div>
            <div class="col-md-12">
                <div class="row">
                    @foreach($category->products->where('published', 1)->where('brand_id', $brand->id) as $product)
                        @include('frontend.products._product')
                    @endforeach
                </div>
            </div>
        @endforeach
    </div>
@endsection