@extends('layouts.client')

@section('content-header')
    <h1>
        Détails news/trend
    </h1>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="box box-primary">
                <!-- form start -->
                    <div class="box-body">
                        <div class="form-group">
                            <label for="exampleInputEmail1">Nom du salon</label>
                            <p class="static-control">
                                {{ $trend->name }}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="">Catégorie</label>
                            <p class="static-control">
                                {{ isset($trend->category)?$trend->category->name:null }}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="description">Adresse</label>
                            <p class="static-control">
                                {{ $trend->adresse }}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="description">Description</label>
                            <p class="static-control">
                                {{ $trend->description }}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="description">lien</label>
                            <p class="static-control">
                                @if(!empty($trend->link))
                                    <a href="{{ $trend->link }}" target="_blank">{{ $trend->link }}</a>
                                @endif
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="description">Image</label>
                            <p class="static-control">
                                @if(isset($trend->image) && !empty($trend->image))
                                    <div>
                                        <img src="{{ asset('storage/companies/'.$trend->company->id.'/trends/'.$trend->image) }}" class="" style="max-width: 300px">
                                    </div>
                                    <br>
                                @endif
                            </p>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <a href="{{ route('clients.trends.edit', $trend->id) }}" class="btn btn-sm btn-primary"><i class="fa fa-edit" aria-hidden="true"></i> Modifier</a>
                        <a href="{{ route('clients.trends.delete', $trend->id) }}" class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i> Supprimer</a>
                    </div>
            </div>
        </div>
    </div>
@endsection