@extends('layouts.client')

@section('content-header')
    <h1>
        Détails de salon
    </h1>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-6 col-md-offset-2">
            <div class="box box-primary">
                <!-- form start -->
                    <div class="box-body">
                        <div class="form-group">
                            <label for="exampleInputEmail1">Nom du salon</label>
                            <p class="static-control">
                                {{ $salon->name }}
                            </p>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <label for="ref" class="col-md-12">Date début/fin:</label>
                                <div class="col-md-3">
                                    <p class="static-control">
                                        {{ isset($salon->date_start)?$salon->date_start->format('d/m/Y'):null }} - {{ isset($salon->date_end)?$salon->date_end->format('d/m/Y'):null }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="coordonnees">Coordonnées du salon</label>
                            <p class="static-control">
                                {!! nl2br($salon->coordonnees) !!}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="description">Ville</label>
                            <p class="static-control">
                                {{ $salon->ville }}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="description">Pays</label>
                            <p class="static-control">
                                {{ $salon->country->name_fr }}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="description">lien</label>
                            <p class="static-control">
                                @if(!empty($salon->link))
                                    <a href="{{ $salon->link }}" target="_blank">{{ $salon->link }}</a>
                                @endif
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="values">Logo/Image</label>
                            @if(isset($salon->image) && !empty($salon->image))
                                <div>
                                    <img src="{{ asset('storage/companies/'.$salon->company->id.'/salons/'.$salon->image) }}" class="" style="max-width: 300px">
                                </div>
                                <br>
                            @endif
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        @if(!$participe)
                        <a href="{{ route('clients.salons.participation', $salon->id) }}" class="btn btn-sm btn-primary"><i class="fa fa-check-square-o" aria-hidden="true"></i> Je participe</a>
                        @else
                            <a href="{{ route('clients.salons.participation.cancel', $salon->id) }}" class="btn btn-sm btn-danger"><i class="fa fa-check-square-o" aria-hidden="true"></i> Annuler la participation</a>
                        @endif
                        
                        
                    </div>
            </div>
        </div>
    </div>
@endsection