@extends('layouts.client')

@section('content-header')
    <h1>
        Creation de produit
    </h1>
@endsection
@section('content')
    {!! Form::open(['route' => ['clients.products.store'], 'class' => '', 'files' => true]) !!}
    <div class="row">
        <div class="col-md-7">
            <div class="box box-primary">
                @include('clients.products._form')
            </div>
            <div class="box box-primary">
                @include('clients.products._seo')
            </div>
        </div>
        <div class="col-md-5">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        Attributs
                    </h3>
                </div>
                <div class="box-body" id="attributs">

                </div>

            </div>
        </div>
        <div class="col-md-12">
            <div class="box box-widget">
                <div class="box-footer text-right">
                    <a href="{{ URL::previous() }}" class="btn btn-danger">Annuler</a>
                    <button type="submit" class="btn btn-primary">Enregistrer</button>
                </div>
            </div>
        </div>
    </div>
    {!! Form::close() !!}
@endsection

@section('scripts')
    <script>
        $(function(){
            $('#category_id').on('change', function(){
                $('#attributs').load('/clients/admin/products/category/' + $(this).val() + '/attributes', function() {

                })
            });
        })
    </script>
@endsection