@extends('layouts.backend')

@section('content-header')
    <h1>
        Slider
    </h1>
@endsection
@section('content')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">

                    </h3>

                    <div class="box-tools">
                    <a href="{{ route('backend.sliders.create') }}" class="btn btn-success pull-right"><i class="fa fa-plus" aria-hidden="true"></i> Ajouter une image</a>

                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body table-responsive no-padding">
                    <table class="table table-hover">
                        <tbody><tr>
                            <th>ID</th>
                            <th>Image</th>
                            <th>Lien</th>
                            <th style="width: 250px;" class="text-right">Action</th>
                        </tr>
                        @foreach($sliders as $item)
                        <tr>
                            <td>{{ $item->id }}</td>
                            <td>
                            @if(isset($item->image) && !empty($item->image))
                                <div>
                                    <img src="{{ asset('storage/sliders/'.$item->image) }}" class="" style="max-width: 400px;">
                                </div>
                                <br>
                            @endif
                            </td>
                            <td>
                                {{ $item->link }} 
                                
                            </td>
                            <td class="text-right">
                                <a href="{{ route('backend.sliders.edit', $item->id) }}" class="btn btn-sm btn-primary"><i class="fa fa-edit" aria-hidden="true"></i></a>
                                <a href="{{ route('backend.sliders.delete', $item->id) }}" class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i></a>
                            </td>
                        </tr>
                        @endforeach

                        </tbody></table>
                </div>
                <!-- /.box-body -->
                <div class="box-footer clearfix">
                </div>
            </div>
            <!-- /.box -->
        </div>
    </div>
@endsection