@extends('layouts.backend')

@section('content-header')
    <h1>
        Détails de projet
    </h1>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="box box-primary">
                <!-- form start -->
                    <div class="box-body">
                        <div class="form-group">
                            <label for="">Entreprise</label>
                            <p class="static-control">
                                {{ $project->company->name }}
                            </p>
                        </div>
                        <div class="form-group">
                            <label for="">Nom du salon</label>
                            <p class="static-control">
                                {{ $project->name }}
                            </p>
                        </div>

                        <div class="form-group">
                            <label for="">Catégorie</label>
                            <p class="static-control">
                                {{ isset($project->category)?$project->category->name:null }}
                            </p>
                        </div>

                        <div class="form-group">
                            <label for="">Adresse</label>
                            <p class="static-control">
                                {{ $project->adresse }}
                            </p>
                        </div>

                        <div class="form-group">
                            <label for="">Description</label>
                            <p class="static-control">
                                {{ $project->description }}
                            </p>
                        </div>


                        <div class="form-group">
                            <label for="description">lien</label>
                            <p class="static-control">
                                @if(!empty($project->link))
                                    <a href="{{ $project->link }}" target="_blank">{{ $project->link }}</a>
                                @endif
                            </p>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <a href="{{ route('backend.projects.edit', $project->id) }}" class="btn btn-sm btn-primary"><i class="fa fa-edit" aria-hidden="true"></i> Modifier</a>
                        <a href="{{ route('backend.projects.delete', $project->id) }}" class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i> Supprimer</a>
                    </div>
            </div>
        </div>
    </div>
@endsection