@extends('layouts.backend') 
@section('content-header')
<h1>
  Imporataion de produits
</h1>
@endsection
 
@section('content')
<div class="row">
  <div class="col-md-6">
    <div class="box box-primary">
      <div class="box-header with-border">
        <h3 class="box-title">
          <i class="fa fa-file-excel-o" aria-hidden="true"></i> Exporter un modéle Excel
        </h3>
      </div>
      <div class="box-body" id="categories_export">
        {!! Form::open(['route' => ['backend.products.import.export'], 'class' => 'form-horizontal']) !!}
        <div class="form-group">
          <label for="name" class="col-md-3 control-label">Catégorie</label>
          <div class="col-md-9">
            {{ Form::select('category_id_l0', $categories, null, ['class' => 'select2 form-control', 'placeholder' => 'Séléctionnez une catégorie...', 'id' => 'category_id_l0', 'required' => 'required']) }}
          </div>
        </div>
        <div class="form-group">
          <div class="col-md-9 col-md-offset-3">
            <div id="categories_container_l1">
              <select name="category_id_l1" id="category_id_l1" required="required" disabled="disabled" class="form-control select2"><option value="">...</option></select>
            </div>
          </div>
        </div>
        <div class="form-group">
          <div class="col-md-9 col-md-offset-3">
            <div id="categories_container_l2">
              <select name="category_id_l2" id="category_id_l2" required="required" disabled="disabled" class="form-control select2"><option value="">...</option></select>
            </div>
          </div>
        </div>
        <div class="form-group">
          <div class="col-md-9 col-md-offset-3">
            <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Exporter</button>
          </div>
        </div>
        {!! Form::close() !!}
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="box box-primary">
      <div class="box-header with-border">
        <h3 class="box-title">
          <i class="fa fa-upload" aria-hidden="true"></i> Importer le fichier Excel
        </h3>
      </div>
      <div class="box-body" id="categories_import">
        {!! Form::open(['route' => ['backend.products.import.store'], 'class' => 'form-horizontal', 'method' => 'POST', 'files' =>
        true]) !!} {{ csrf_field() }}
        {{-- <div class="form-group">
          <label for="company_id" class="col-md-3 control-label">Entreprise</label>
          <div class="col-md-9">
            {{ Form::select('company_id', $companies , null, [ 'class' => 'form-control select2', 'placeholder' => 'Sélectionnez une
            entreprise...', 'required' => 'required', 'id' => 'company_id' ]) }}
          </div>
        </div> --}}
        
        <div class="form-group">
          <label for="brand_id" class="col-md-3 control-label">Marque</label>
          <div class="col-md-9">
            {{ Form::select('brand_id', $brands , null, [ 'class' => 'form-control select2', 'placeholder' => 'Sélectionnez une
            marque...', 'required' => 'required', 'id' => 'brand_id' ]) }}
          </div>
        </div>
        {{-- <div class="form-group">
          <label for="name" class="col-md-3 control-label">Catégorie</label>
          <div class="col-md-9">
            {{ Form::select('category_id', $categories, null, ['class' => 'select2 form-control', 'placeholder' => 'Sélectionnez une
            catégorie...', 'required' => 'required']) }}
          </div>
        </div> --}}


        <div class="form-group">
          <label for="name" class="col-md-3 control-label">Catégorie</label>
          <div class="col-md-9">
            {{ Form::select('category_id_l0', $categories, null, ['class' => 'select2 form-control', 'placeholder' => 'Séléctionnez une catégorie...', 'id' => 'category_id_l0', 'required' => 'required']) }}
          </div>
        </div>

        <div class="form-group">
          <div class="col-md-9 col-md-offset-3">
            <div id="categories_container_l1">
              <select name="category_id_l1" id="category_id_l1" required="required" disabled="disabled" class="form-control select2"><option value="">...</option></select>
            </div>
          </div>
        </div>

        <div class="form-group">
          <div class="col-md-9 col-md-offset-3">
            <div id="categories_container_l2">
              <select name="category_id_l2" id="category_id_l2" required="required" disabled="disabled" class="form-control select2"><option value="">...</option></select>
            </div>
          </div>
        </div>

        <div class="form-group">
          <label for="name" class="col-md-3 control-label">Publier les produits</label>
          <div class="col-md-9">
            {{ Form::select('publish', ['1' => 'Oui', '0' => 'Non'], null, ['class' => 'select2 form-control', 'required' => 'required']) }}
          </div>
        </div>

        <div class="form-group">
          {!! Form::label('file', 'Fichier XLSX', ['class' => 'col-md-3 control-label']) !!}
          <div class="col-md-9">
            <div class="input-file">
            {!! Form::file('fileimport', null, ['class'=>'form-control', 'required'=>'required']) !!}
            <button class="btn btn-success" type="button"><i class="fa fa-folder-open" aria-hidden="true"></i> Choisissez un fichier</button>
            </div>
            <br>
            <br>
          </div>
        </div>
        <div class="form-group">
          <div class="col-md-9 col-md-offset-3">
            <button type="submit" class="btn btn-success"><i class="fa fa-upload" aria-hidden="true"></i> Importer</button>
          </div>
        </div>


<style>

.input-file {
  float: left;
  position: relative;
  padding-right: 140px;
  min-height: 40px;
  padding-left: 10px;
  line-height: 50px;
  color: #9e9e9e;
 
  
}
 .input-file input[type="file"] {
	position: absolute;
	right: 0;
	top: 4px;
	height: 40px;
	width: 130px;
	margin:0;
	z-index: 2;
	opacity: 0;
	cursor: pointer;
  }
   .input-file button.btn {
    position: absolute;
    left: 0;
    top: 0px;
    z-index: 1;
    -webkit-border-radius: 0px;
    -moz-border-radius: 0px;
    border-radius: 0px;
    height: 46px;
  }
</style>
        {!! Form::close() !!}
      </div>
    </div>
  </div>
</div>
@endsection

@section('scripts')
<script>  
  $(function(){
    $('form #category_id_l0').on('change', function(){
        var $parent = $(this).parents('form');
        var $selected_cat = $(this).val();
        if($selected_cat) {
            $parent.find('#categories_container_l1').load('/admin/products/import/categories/'+$selected_cat+'/select', function() {
                $('.select2').select2();
            })
            $parent.find('#categories_container_l2').html('<select name="category_id_l2" id="category_id_l2" required="required" disabled="disabled" class="form-control select2"><option value="">...</option></select>');
        }else{
            $parent.find('#categories_container_l1').html('<select name="category_id_l1" id="category_id_l1" required="required" disabled="disabled" class="form-control select2"><option value="">...</option></select>');
            $parent.find('#categories_container_l2').html('<select name="category_id_l2" id="category_id_l2" required="required" disabled="disabled" class="form-control select2"><option value="">...</option></select>');
        }
    });

    $('form #categories_container_l1').on('change', '#category_id_l1', function(){
        var $parent = $(this).parents('form');
        var $selected_cat = $(this).val();
        if($selected_cat) {
            $parent.find('#categories_container_l2').load('/admin/products/import/categories/'+$selected_cat+'/select', function() {
                $('.select2').select2();
            })
        }else{
            $parent.find('#categories_container_l2').html('<select name="category_id_l2" id="category_id_l2" required="required" disabled="disabled" class="form-control select2"><option value="">...</option></select>');
        }
    });
  })
</script>
@endsection