@extends('layouts.backend')

@section('content-header')
    <h1>
        Modification de produit
    </h1>
@endsection
@section('content')
    {!! Form::model($product, ['route' => ['backend.products.update', $product->id], 'class' => '', 'method' => 'PUT', 'files' => true]) !!}
    <div class="row">
        <div class="col-md-7">
            <div class="box box-primary">
                @include('backend.products._form')
            </div>
            <div class="box box-primary">
                @include('backend.products._seo')
            </div>
        </div>
        <div class="col-md-5">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        Attributs
                    </h3>
                </div>
                <div class="box-body" id="attributs">
                    {{-- 
                    @foreach($attributes as $attribute)
                        @include('shared.attributes.'. $attribute->type .'.edit', ['attribute' => $attribute, 'db_value' => $product_attributes->get($attribute->id)])
                    @endforeach
                    --}}
                    @foreach($attributes as $attribute)
                        @if($attribute->childs->count() > 0 )
                            <div class="col-md-12 has_childs" data-filter_id="{{ $attribute->id }}">
                         @else
                            <div class="col-md-12">
                         @endif
                         @include('shared.attributes.'. $attribute->type .'.edit', ['attribute' => $attribute, 'db_value' => $product_attributes->get($attribute->id)])
                        </div>
                        @foreach ($attribute->childs as $child)
                        {{-- parent selected value --}} 
                            <div class="col-md-12" @if(trim($product_attributes->get($attribute->id)) != trim($child->parent_value))style="display: none;" disabled @endif data-filter_parent_id="{{ $attribute->id }}" data-filter_parent_value="{{ $child->parent_value }}">
                                @include('shared.attributes.'. $child->type .'.edit', ['attribute' => $child, 'db_value' => $product_attributes->get($child->id)])
                            </div>
                        @endforeach
                    @endforeach
                </div>

            </div>
        </div>
        <div class="col-md-12">
            <div class="box box-widget">
                <div class="box-footer text-right">
                    <a href="{{ URL::previous() }}" class="btn btn-danger">Annuler</a>
                    <button type="submit" class="btn btn-primary">Enregistrer</button>
                </div>
            </div>
        </div>
    </div>
    {!! Form::close() !!}
@endsection

@section('scripts')
    <script>
        $(function(){

            {{-- $("#search").keyup(function () {
                var filter = $(this).val();
                $("#categories-list .category-item:not([data-selected='1'])").each(function () {
                    if ($(this).text().search(new RegExp(filter, "i")) < 0) {
                        $(this).hide();
                    } else {
                        $(this).show()
                    }
                });
            });

            $("a.category-item").on('click', function(event){
                event.preventDefault();

                var $idCategory = $(this).data('position');
                var $nameCategory = $(this).data('category');
                console.log($idCategory);
                $(".close-search").click();
                $("#search").val($nameCategory);
                $("#category_id").val($idCategory);
                $('#attributs').load('/admin/products/category/' + $idCategory + '/attributes', function() {});
            });

            $("#search").on('focus', function(event) {
                $('.categories-container').show();
                $(".close-search").show();
            });
            $(".close-search").on('click', function(event) {
                event.preventDefault();
                $("#search").val("");
                $("#search").keyup();

                $('.categories-container').hide();
                $(".close-search").hide();
            }); --}}


            $('body').on('change', '#category_id',function(){
                console.log("Test");
                $('#attributs').load('/admin/products/category/' + $(this).val() + '/attributes', function() {});
            });
        })
    </script>
@endsection