<div class="">
    <input type="text" name="search" id="search" placeholder="Recherche une catégorie..." class="form-control" autocomplete="off">
    <a href="#" class="close-search" style="display: none;">
        <i class="fa fa-close"></i>
    </a>
</div>
<div class="categories-container" style="display: none;">
    <div class="list-group" id="categories-list">
        @foreach($categories as $category)
            <a href="{{ route('backend.attributes.index', $category->id) }}" class="category-item list-group-item"
                id="cat-{{ $category->id }}"
                data-position="{{ $category->id }}"
                data-href=""
            >
                {{ $category->parent->name }} > {{ $category->name }}
                <br>
                <small>
                    <strong>{{ $category->parent->parent->name }}</strong>
                </small>
                <i class="fa fa-chevron-right pull-right" aria-hidden="true"></i>

            </a>
        @endforeach
    </div>
</div>

<style>
    .close-search {
        position: absolute;
        right: 25px;
        top: 10px;
        color: #000000;
    }
    .close-search:hover {
        color: #000;
    }
    .categories-container {
        position: absolute;
        z-index: 100;
        width: 100%;
        padding-right: 30px;
    }
    .list-group {
        max-height: 500px;
        overflow: auto;
        border-radius: 0px;
        border: 1px solid #cccccc;
    }
    .list-group-item {
        border: none;
        border-top: 1px solid #cccccc;
        padding-right: 20px;
    }
    .list-group-item:first-child {
        border-top-left-radius: 0px;
        border-top-right-radius: 0px;
        border-top: none;
    }
</style>