@extends('layouts.backend')

@section('content-header')
<h1>
    @if($company->published)
    <i class="fa fa-check-square-o fa-lg" style="color:green" aria-hidden="true"></i>
    @else
    <i class="fa fa-ban fa-lg danger" style="color:red" aria-hidden="true"></i>
    @endif
    Détails de l'entreprise
</h1>
@endsection
@section('content')
<div class="row">
    <div class="col-md-6">
        <div class="box box-primary">
            <!-- form start -->
            <div class="box-body">

                <div class="form-group">
                    <label for="name">Nom de l'entreprise</label>
                    <p class="static-control">
                        {{ $company->name }}
                    </p>
                </div>
                <div class="form-group">
                    <div class="row">
                        <div class="col-md-6">
                            <label for="name">Forme social</label>
                            <p class="static-control">
                                {{ $company->display_forme_social }}
                            </p>
                        </div>
                        <div class="col-md-6">
                            <label for="name">Taille de l'entreprise</label>
                            <p class="static-control">
                                {{ $company->display_company_size }}
                            </p>
                        </div>
                    </div>
                </div>


                <div class="form-group">
                    <label for="name">Le groupe</label>
                    <p class="static-control">
                        @if(isset($company->groupe))
                        <a href="{{ route('backend.companies.show', $company->groupe->id) }}">
                            {{ $company->groupe->name }}
                        </a>
                        @else
                        -
                        @endif
                    </p>
                </div>

                <div class="form-group">
                    <label for="description">Secteur Privé/Public</label>
                    <p class="static-control">
                        @if($company->secteur == "prive")
                        Privé
                        @elseif($company->secteur == "public")
                        Public
                        @endif
                    </p>
                </div>

                <div class="form-group">
                    <div class="row">
                        <div class="col-md-6">
                            <label for="name">Secteur d'activité</label>
                            <p class="static-control">
                                {{ isset($company->secteur_activite)?$company->secteur_activite->name:'' }}
                            </p>
                        </div>
                        <div class="col-md-6">
                            <label for="name">Nature d'activité</label>
                            <p class="static-control">
                                {{ isset($company->nature_activite)?$company->nature_activite->name:'' }}
                            </p>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="description">Qui sommes-nous ?</label>
                    <p class="static-control">
                        {{ $company->description }}
                    </p>
                </div>

                {{-- <div class="form-group">
                            <label for="values">Nos valeurs</label>
                            <p class="static-control">
                                {{ $company->values }}
                </p>
            </div> --}}

            <div class="form-group">
                <label for="values">Logo</label>
                @if(isset($company->image) && !empty($company->image))
                <div>
                    <img src="{{ asset('storage/companies/'.$company->id.'/'.$company->image) }}" class=""
                        style="max-width: 300px">
                </div>
                <br>
                @endif
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label for="phone">Prénom Contact</label>
                        <p class="static-control">
                            {{ $company->prenom }}
                        </p>
                    </div>
                    <div class="col-md-6">
                        <label for="mobile">Nom Contact</label>
                        <p class="static-control">
                            {{ $company->nom }}
                        </p>
                    </div>
                    <div class="col-md-6">
                        <label for="phone">Fonction du contact</label>
                        <p class="static-control">
                            {{ $company->contact_fonction }}
                        </p>
                    </div>
                    <div class="col-md-6">
                        <label for="mobile">Email du contact</label>
                        <p class="static-control">
                            {{ $company->contact_email }}
                        </p>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="email">Email de l'entreprise</label>
                <p class="static-control">
                    {{ $company->email }}
                </p>
            </div>

            <div class="form-group">
                <label for="email">Site Web</label>
                <p class="static-control">
                    @if(!empty($company->site ))
                    <a href="{{ $company->site  }}" target="_blank">{{ $company->site  }}</a>
                    @endif
                </p>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label for="phone">Téléphone</label>
                        <p class="static-control">
                            {{ $company->phone }}
                        </p>
                    </div>
                    <div class="col-md-6">
                        <label for="fax">Fax</label>
                        <p class="static-control">
                            {{ $company->fax }}
                        </p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label for="mobile">Mobile</label>
                        <p class="static-control">
                            {{ $company->mobile }}
                        </p>
                    </div>
                    <div class="col-md-6">
                        <label for="mobile">Mobile 2</label>
                        <p class="static-control">
                            {{ $company->mobile2 }}
                        </p>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="adresse">Adresse</label>
                <p class="static-control">
                    {{ $company->adresse }}
                </p>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label for="mobile">Wilaya</label>
                        <p class="static-control">
                            {{ isset($company->wilaya)?$company->wilaya->name:'' }}
                        </p>
                    </div>
                    <div class="clearfix"></div>
                    <div class="col-md-6">
                        <label for="mobile">Commune</label>
                        <p class="static-control">
                            {{ isset($company->commune)?$company->commune->name:'' }}
                        </p>
                    </div>
                    <div class="col-md-6">
                        <label for="mobile">Code postal</label>
                        <p class="static-control">
                            {{ $company->codepostal }}
                        </p>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="adresse">Pays</label>
                <p class="static-control">
                    {{ $company->country->name_fr }}
                </p>
            </div>
            <div class="row">
                <div class="col-md-12">

                    <iframe width="100%" height="300" frameborder="0" scrolling="no" marginheight="0" marginwidth="0"
                        src="https://maps.google.com/maps?q={{ $company->lat }},{{ $company->long }}&hl=fr;z=14&amp;output=embed"></iframe>

                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <label for="company_rc">N° de Registre de commerce</label>
                        <p class="static-control">{{ $company->company_rc }}</p>
                    </div>
                    <div class="col-md-12">
                        <label for="company_nif">NIF</label>
                        <p class="static-control">{{ $company->company_nif }}</p>
                    </div>
                    <div class="col-md-12">
                        <label for="company_ai">Article d'imposition</label>
                        <p class="static-control">{{ $company->company_ai }}</p>
                    </div>
                    <div class="col-md-12">
                        <label for="company_ai">Numéro d'Identification Statistique</label>
                        <p class="static-control">{{ $company->company_nis }}</p>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
            <a href="{{ route('backend.companies.edit', $company->id) }}" class="btn btn-sm btn-primary"><i
                    class="fa fa-edit" aria-hidden="true"></i> Modifier</a>
            <a href="{{ route('backend.companies.delete', $company->id) }}" class="btn btn-sm btn-danger"
                data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i> Supprimer</a>
        </div>
    </div>
</div>
<div class="col-md-6">
    <div class="box box-primary">
        <div class="box-header">
            <h3 class="box-title">
                Utilisateurs
            </h3>

            <div class="box-tools">
                <a href="{{ route('backend.companies.users.create', $company->id) }}" data-toggle="modal"
                    data-target="#modal" class="btn btn-sm btn-success"><i class="fa fa-plus" aria-hidden="true"></i>
                    Ajouter un utilisateur</a>
            </div>
        </div>

        <div class="box-body table-responsive no-padding">
            <table class="table table-hover">
                <tbody>
                    <tr>
                        <th>Nom</th>
                        <th>Email</th>
                        <th style="width: 150px;" class="text-right">Action</th>
                    </tr>
                    @foreach($company->users as $user)
                    <tr>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->email }}</td>
                        <td class="text-right">
                            <a href="{{ route('backend.companies.users.edit', [$company->id, $user->id]) }}"
                                data-toggle="modal" data-target="#modal" class="btn btn-sm btn-primary"><i
                                    class="fa fa-edit" aria-hidden="true"></i></a>
                            <a href="{{ route('backend.companies.users.delete', [$company->id, $user->id]) }}"
                                class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash"
                                    aria-hidden="true"></i></a>
                        </td>
                    </tr>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>

    <hr>

    {{-- <div class="box box-primary">
                <div class="box-header">
                    <h3 class="box-title">
                        Catégories
                    </h3>

                    <div class="box-tools">
                        <a href="{{ route('backend.companies.categories', $company->id) }}" data-toggle="modal"
    data-target="#modal-xlg" class="btn btn-sm btn-success">
    <i class="fa fa-edit" aria-hidden="true"></i> Modifier les catégories
    </a>
</div>
</div>

<div class="box-body no-padding">
    <table class="table table-hover">
        <tbody>
            @foreach($company->categories_list as $category)
            <tr>
                <td>{{ $category->category->parent->name }} > {{ $category->category->name }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
</div> --}}
<div class="box box-primary">
    <div class="box-header with-border">
        <h3 class="box-title">
            Les produits proposé par l'entreprise <span>({{ $company->products->count() }} produits)</span>
        </h3>
    </div>
    <div class="box-body table-responsive no-padding" id="attributs">
        <table class="table table-hover">
            <tbody>
                <tr>
                    <th>Ref</th>
                    <th>Nom</th>
                </tr>
                @foreach($company->products->take(10) as $product)
                <tr>
                    <td>{{ $product->ref }}</td>
                    <td>{{ $product->name }}</td>
                </tr>
                @endforeach

            </tbody>
        </table>
    </div>
    <div class="box-footer text-center">
        <a href="{{ route('backend.companies.products.index', $company->id) }}" class="uppercase">Voir tous les
            produits</a>
    </div>
</div>
</div>
</div>
@endsection