{!! Form::open(['route' => ['backend.companies.products.add', $company->id], 'class' => 'form-horizontal', 'method' => 'POST']) !!}
<div class="modal-header no-border">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
    <h4 class="modal-title">
        Ajouter un produit
    </h4>
</div>
<div class="modal-body">
  <div class="row">
    <span id="categories_container_l0" class="col-md-4">
        {{ Form::select('category_id_l0', $categories_l0, isset($product)?$product->category->parent->parent->id:null, [
            'class' => 'form-control select2 w100',
            'placeholder' => 'Séléctionnez une catégorie...',
            'required' => 'required',
            'id' => 'category_id_l0',
            'style' => 'width: 100%',
        ]) }}
    </span>
    <span id="categories_container_l1" class="col-md-4">
        {{ Form::select('category_id_l1', isset($categories_l1)?$categories_l1:[], isset($product)?$product->category->parent->id:null, [
            'class' => 'form-control select2 w100',
            'placeholder' => 'Séléctionnez une catégorie...',
            'required' => 'required',
            'id' => 'category_id_l1',
            'disabled' => !isset($product),
            'style' => 'width: 100%',
        ]) }}
    </span>
    <span id="categories_container_l2" class="col-md-4">
        {{ Form::select('category_id', isset($categories_l2)?$categories_l2:[], isset($product)?$product->category->id:null, [
            'class' => 'form-control select2 w100',
            'placeholder' => 'Séléctionnez une catégorie...',
            'required' => 'required',
            'id' => 'category_id',
            'disabled' => !isset($product),
            'style' => 'width: 100%',
        ]) }}
    </span>
</div>

  <div class="row">
    <div class="col-md-12">
      <br />
    </div>
    <div class="col-md-6">
      <div style="padding-bottom: 20px;">
        <input type="text" name="search" id="search" class="form-control" placeholder="Filtrer la liste">
      </div>
      <div class="products-modal-list" id="products-modal-list" data-href="{{ route('backend.companies.products.search', $company->id) }}">

        <div class="products-model-message">
          Merci de rechercher et de séléctionner des produits à ajouter <br> <br>
          <i class="fa fa-cubes fa-5x" aria-hidden="true"></i>
        </div>
      </div>
      
    </div>

    <div class="col-md-6">
      <div style="padding-bottom: 20px;">
        {{-- <input type="text" name="" id="" class="form-control" placeholder="Filtrer la liste"> --}}
        <div style="height: 36px"></div>
      </div>
      <div id="select_products" class="products-modal-list">

      </div>
    </div>
  </div>
</div>
<div class="modal-footer no-border">
    <button type="button" class="btn btn-danger pull-left" data-dismiss="modal">Fermer</button>
    <button type="submit" class="btn btn-success">Enregistrer</button>
</div>
{!! Form::close() !!}

<script>
$(function(){
  $('.select2').select2();
  $('#search').on('keypress', function(e) {
    var keyCode = e.keyCode || e.which;
    if (keyCode === 13) { 
      e.preventDefault();
      return false;
    }
  });
  $('#search').bind('keyup', function() {
   
    var searchString = $(this).val();

    $("#products-modal-list li").each(function(index, value) {
        currentName = $(value).find('label').text()
        if( currentName.toUpperCase().indexOf(searchString.toUpperCase()) > -1) {
           $(value).show();
        } else {
            $(value).hide();
        }
        
    });
    
});

  {{-- // disable enter key
  $('#query').on('keypress', function(e) {
    var keyCode = e.keyCode || e.which;
    if (keyCode === 13) { 
      e.preventDefault();
      $('#query').blur();
      return false;
    }
  });
  $('#query').on('change', function(){
    $selected = $(this).val();
    $('#products-modal-list').load( $('#products-modal-list').data('href') + '?q=' + encodeURIComponent($selected));
    $('#query').val(null);
  }); --}}


 $('#category_id_l0').on('change', function(){
    var $selected_cat = $(this).val();
    if($selected_cat) {
        $('#categories_container_l1').load('/categories/'+$selected_cat+'/select?level=1', function() {
            $('.select2').select2();
        })
    }else{
        $('#categories_container_l1').html('<select name="category_id" id="category_id" class="form-control select2 w100" disabled><option value="">Sélectionnez une catégorie...</option></select>');
        $('#categories_container_l2').html('<select name="category_id" id="category_id" class="form-control select2 w100" disabled><option value="">Sélectionnez une catégorie...</option></select>');
        $('.select2').select2();
    }
});

$('#categories_container_l1').on('change', '#category_id_l1', function(){
    var $selected_cat = $(this).val();
    if($selected_cat) {
        $('#categories_container_l2').load('/categories/'+$selected_cat+'/select?level=2', function() {
          $('.select2').select2();
        })
    }else{
        $('#categories_container_l2').html('<select name="category_id" id="category_id" class="form-control select2 w100" disabled><option value="">Sélectionnez une catégorie...</option></select>');
        $('.select2').select2();
    }
});

$('#categories_container_l2').on('change', '#category_id', function(){
    {{-- var $selected_cat = $(this).val();
    if($selected_cat) {
      var $page_url = $("#current_url").val();
      if($page_url)
      document.location.href = $page_url + '/' +$selected_cat;
    } --}}

    $selected_cat = $(this).val();
    $('#products-modal-list').load( $('#products-modal-list').data('href') + '?q=' + encodeURIComponent($selected_cat), function(){
      $('#search').focus();
    });
});







  $('body').on('change', "#products-modal-list .list-group-item input[type='checkbox']", function(event){
      event.preventDefault();
      $selected = $(this).val();
      if($("#select_products").find('.list-group-item-' + $selected).length == 0){
        $("#products-modal-list .list-group-item-" + $selected).appendTo("#select_products");
        $("#select_products").find('.list-group-item:last').find('a').remove();
        $("#select_products").find('.list-group-item:last').find('input').attr('name', 'id[]');
      }else{
        $("#products-modal-list .list-group-item-" + $selected).remove();
      }
  });

  $('body').on('change', "#select_products .list-group-item input[type='checkbox']", function(event){
      event.preventDefault();
      $(this).parents('.list-group-item').remove();
  });

})

</script>