@extends('layouts.backend')

@section('content-header')
<h1>
    Détails marque
</h1>
@endsection
@section('content')
<div class="row">
    <div class="col-md-7">
        <div class="box box-primary">
            <!-- form start -->
            <div class="box-body">
                <div class="form-group">
                    <label for="">Marque</label>
                    <p class="static-control">
                        {{ $brand->name }}
                    </p>
                </div>
                <div class="form-group">
                    <label for="">Caregorie</label>
                    <p class="static-control">
                        {{ $brand->category->name }}
                    </p>
                </div>
                <div class="form-group">
                    <label for="description">Description</label>
                    <p class="static-control">
                        {{ $brand->description }}
                    </p>
                </div>
                <div class="form-group">
                    <label for="description">Logo</label>
                    <p class="static-control">
                        @if(isset($brand->logo) && !empty($brand->logo))
                        <div>
                            <img src="{{ asset('storage/brands/'.$brand->logo) }}" class="" style="max-width: 300px">
                        </div>
                        <br>
                        @endif
                    </p>
                </div>
            </div>
            <!-- /.box-body -->
            <div class="box-footer">
                <a href="{{ route('backend.brands.edit', $brand->id) }}" class="btn btn-sm btn-primary"><i
                        class="fa fa-edit" aria-hidden="true"></i> Modifier</a>
                <a href="{{ route('backend.brands.delete', $brand->id) }}" class="btn btn-sm btn-danger"
                    data-confirm="delete"><i class="fa fa-trash" aria-hidden="true"></i> Supprimer</a>
            </div>
        </div>
    </div>
    <div class="col-md-5">
        <div class="box box-primary">
            {{-- <div class="box-header with-border">
                    <h3 class="box-title">
                        Catalogues
                    </h3>
                </div> --}}
            <div class="box-header">
                <h3 class="box-title">
                    Catalogues
                </h3>

                <div class="box-tools">
                    <a href="{{ route('backend.brands.catalogues.create', $brand->id) }}" data-toggle="modal"
                        data-target="#modal" class="btn btn-sm btn-success"><i class="fa fa-plus"
                            aria-hidden="true"></i> Ajouter un catalogue</a>
                </div>
            </div>
            <div class="box-body table-responsive no-padding">
                <table class="table table-hover">
                    <tbody>
                        <tr>
                            <th>Catalogue</th>
                            <th>Pages</th>
                            <th>Archive</th>
                            <th style="width: 150px;" class="text-right">Action</th>
                        </tr>
                        @foreach($catalogues as $catalogue)
                        <tr>
                            <td>
                                {{ $catalogue->name }}
                                <br>
                                <a href="{{ asset('storage/brands/'.$brand->id .'/catalogues/' . $catalogue->filename) }}"
                                    target="_blank">{{ $catalogue->filename }}</a>
                            </td>
                            <td>
                                {{ $catalogue->number_pages }}
                            </td>
                            <td>{{ $catalogue->archive }}</td>
                            <td class="text-right">
                                <a href="{{ route('backend.brands.catalogues.edit', [$brand->id, $catalogue->id]) }}"
                                    data-toggle="modal" data-target="#modal" class="btn btn-sm btn-primary"><i
                                        class="fa fa-edit" aria-hidden="true"></i></a>
                                <a href="{{ route('backend.brands.catalogues.delete', [$brand->id, $catalogue->id]) }}"
                                    class="btn btn-sm btn-danger" data-confirm="delete"><i class="fa fa-trash"
                                        aria-hidden="true"></i></a>
                            </td>
                        </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
            <div class="box-body" id="attributs">

            </div>
        </div>

        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">
                    Les produits proposé par la marque <span>({{ $brand->products->count() }} produits)</span>
                </h3>
            </div>
            <div class="box-body table-responsive no-padding" id="attributs">
                <table class="table table-hover">
                    <tbody>
                        <tr>
                            <th>Ref</th>
                            <th>Nom</th>
                        </tr>
                        @foreach($brand->products->take(10) as $product)
                        <tr>
                            <td>{{ $product->ref }}</td>
                            <td>{{ $product->name }}</td>
                        </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
            <div class="box-footer text-center">
                <a href="{{ route('backend.brands.products.index', $brand->id) }}" class="uppercase">Voir tous les
                    produits</a>
            </div>
        </div>
    </div>
</div>
@endsection