@extends('layouts.backend')

@section('content-header')
<h1>
    Attributs dynamiques
</h1>
@endsection
@section('content')
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title">

                </h3>
            </div>

            <div class="box-body no-padding">


                <div class="clearfix"></div>
                <div class="col-md-12">
                    <div class="row">
                        <span id="categories_container_l0" class="col-md-4">
                            <input type="hidden" name="current_url" id="current_url"
                                value="{{ route('backend.attributes.index') }}">
                            <select name="category_id_l0" id="category_id_l0" class="form-control select2 w100">
                                <option value="">Sélectionnez une catégorie...</option>
                                @foreach($categories as $key => $categoryItem)
                                <option value="{{ $categoryItem->id }}">{{ $categoryItem->name }}</option>
                                @endforeach
                            </select>
                        </span>
                        <span id="categories_container_l1" class="col-md-4">
                            <select name="category_id_l1" id="category_id_l1" class="form-control select2 w100"
                                disabled>
                                <option value="">Sélectionnez une catégorie...</option>
                            </select>
                        </span>
                        <span id="categories_container_l2" class="col-md-4">
                            <select name="category_id" id="category_id" class="form-control select2 w100" disabled>
                                <option value="">Sélectionnez une catégorie...</option>
                            </select>
                        </span>
                    </div>
                </div>
                <div class="clearfix"></div>
                @if(empty($category))
                <div class="col-md-6">
                    <h3>
                        <i class="fa fa-arrow-up" aria-hidden="true"></i>
                        Sélectionnez une catégorie
                    </h3>
                    <br><br><br>
                </div>
                @else
                <div class="col-md-6">
                    <br>
                    <div class="panel panel-default">
                        <div class="panel-body">
                            {{ $category->parent->parent->name }} > {{ $category->parent->name }} >
                            {{ $category->name }}
                        </div>
                    </div>
                </div>

                @endif
                <div class="col-md-6">
                    <br>
                    @if(!empty($category))
                    <a href="{{ route('backend.attributes.create', $category->id) }}" data-toggle="modal"
                        data-target="#modal" class="btn btn-success pull-right">
                        <i class="fa fa-plus" aria-hidden="true"></i> Ajouter un attribut
                    </a>
                    @endif

                </div>
                <br><br>

            </div>
        </div>
        @if(!empty($category))
        @include('backend.attributes._attributes')
        @endif
    </div>
</div>
@endsection

<style>
    #attributes-form .form-group {
        margin-bottom: 30px;
    }
</style>

@section('scripts')
<script>
    $(function () {
            $("#search").keyup(function () {
                var filter = $(this).val();
                $("#categories-list .category-item:not([data-selected='1'])").each(function () {
                    if ($(this).text().search(new RegExp(filter, "i")) < 0) {
                        $(this).hide();
                    } else {
                        $(this).show()
                    }
                });
            });
            $("#search").on('focus', function(event) {
                $('.categories-container').show();
                $(".close-search").show();
            });
            $(".close-search").on('click', function(event) {
                event.preventDefault();
                $("#search").val("");
                $("#search").keyup();

                $('.categories-container').hide();
                $(".close-search").hide();
            });

            $('#attribute_type').on('change', function(event){
                var $selected_type = $(this).val();
                $('.type_container').hide();
                $('#type_' + $selected_type).show();

            });
        })
</script>
@endsection