$(function(){
    // Set up a global AJAX error handler to handle the 401
    // unauthorized responses. If a 401 status code comes back,
    // the user is no longer logged-into the system and can not
    // use it properly.
    $.ajaxSetup({
        statusCode: {
            401: function() {
                // Redirec the to the login page.
                document.location.href = "/";
            }
        }
    });

    //Delete link : <a href="/link" data-confirm="delete" data-message="Message">Delete</a>
    $('body').on('click', 'a[data-confirm]', function(ev) {
        var href = $(this).attr('href');
        var remote = $(this).attr('data-remote') == "true";

        var confirm_text = $(this).attr('data-message');
        if (!confirm_text) {
            confirm_text = "Etes-vous sûr de vouloir supprimer cet enregistrement?";
        }

        if (!$('#dataConfirmModal').length) {
            $('body').append('<div id="dataConfirmModal" class="modal fade" role="dialog" aria-labelledby="dataConfirmLabel" aria-hidden="true">' +
                '<div class="modal-dialog">' +
                '<div class="modal-content">' +
                '' +
                '<div class="modal-body">' +
                '<h4></h4>' +
                '</div>' +
                '<div class="modal-footer no-border">' +
                '<button class="btn btn-primary pull-left" data-dismiss="modal" aria-hidden="true">Annuler</button>' +
                '<a class="btn btn-danger" id="dataConfirmOK">Confirmer</a>' +
                '</div>' +
                '</div>' +
                '</div>' +
                '</div>');
        }

        $('#dataConfirmModal').find('.modal-body h4').text(confirm_text);
        if (remote) {
            $('#dataConfirmOK').addClass('deleteRemote');
            $('#dataConfirmOK').attr('href', href);
        } else {
            $('#dataConfirmOK').attr('href', href);
        }
        $('#dataConfirmModal').modal({ show: true });

        return false;
    });

// Remove remote content from modal after hidding
    $('body').on('hidden.bs.modal ', '.modal.remote', function() {
        $(this).removeData('bs.modal').find(".modal-content").empty().html('<div class="text-center"> <br><br> <h3>Chargement ...</h3> <br><br> </div>');
    });
});