<?php

use App\Models\TrendCategory;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TrendCategoriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->command->info('Trend Categories table seeding start');
        $data = [

            ['id' => 1 , 'name' => "Tendances produits"],
            ['id' => 2 , 'name' => "Actualités du secteur"],
            ['id' => 3 , 'name' => "People"],
            ['id' => 4 , 'name' => "Salons et évènements"],
            ['id' => 5 , 'name' => "Livres blancs"],
        ];

        DB::table('trend_categories')->delete();
        TrendCategory::insert($data);
        $categories = TrendCategory::all();
        foreach ($categories as $category) {
            $category->slug = str_slug($category->name);
            $category->save();
        }
        $this->command->info('Trend Categories table seeding end');
    }
}
