<?php

use App\Models\Country;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CountriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->command->info('Countries table seeding start');
        $countries = [
            ['id' => '1', 'code' => '4', 'alpha2' => 'AF', 'alpha3' => 'AFG', 'name_en' => 'Afghanistan', 'name_fr' => 'Afghanistan'],
            ['id' => '2', 'code' => '8', 'alpha2' => 'AL', 'alpha3' => 'ALB', 'name_en' => 'Albania', 'name_fr' => 'Albanie'],
            ['id' => '3', 'code' => '10', 'alpha2' => 'AQ', 'alpha3' => 'ATA', 'name_en' => 'Antarctica', 'name_fr' => 'Antarctique'],
            ['id' => '4', 'code' => '12', 'alpha2' => 'DZ', 'alpha3' => 'DZA', 'name_en' => 'Algeria', 'name_fr' => 'Algérie'],
            ['id' => '5', 'code' => '16', 'alpha2' => 'AS', 'alpha3' => 'ASM', 'name_en' => 'American Samoa', 'name_fr' => 'Samoa Américaines'],
            ['id' => '6', 'code' => '20', 'alpha2' => 'AD', 'alpha3' => 'AND', 'name_en' => 'Andorra', 'name_fr' => 'Andorre'],
            ['id' => '7', 'code' => '24', 'alpha2' => 'AO', 'alpha3' => 'AGO', 'name_en' => 'Angola', 'name_fr' => 'Angola'],
            ['id' => '8', 'code' => '28', 'alpha2' => 'AG', 'alpha3' => 'ATG', 'name_en' => 'Antigua and Barbuda', 'name_fr' => 'Antigua-et-Barbuda'],
            ['id' => '9', 'code' => '31', 'alpha2' => 'AZ', 'alpha3' => 'AZE', 'name_en' => 'Azerbaijan', 'name_fr' => 'Azerbaïdjan'],
            ['id' => '10', 'code' => '32', 'alpha2' => 'AR', 'alpha3' => 'ARG', 'name_en' => 'Argentina', 'name_fr' => 'Argentine'],
            ['id' => '11', 'code' => '36', 'alpha2' => 'AU', 'alpha3' => 'AUS', 'name_en' => 'Australia', 'name_fr' => 'Australie'],
            ['id' => '12', 'code' => '40', 'alpha2' => 'AT', 'alpha3' => 'AUT', 'name_en' => 'Austria', 'name_fr' => 'Autriche'],
            ['id' => '13', 'code' => '44', 'alpha2' => 'BS', 'alpha3' => 'BHS', 'name_en' => 'Bahamas', 'name_fr' => 'Bahamas'],
            ['id' => '14', 'code' => '48', 'alpha2' => 'BH', 'alpha3' => 'BHR', 'name_en' => 'Bahrain', 'name_fr' => 'Bahreïn'],
            ['id' => '15', 'code' => '50', 'alpha2' => 'BD', 'alpha3' => 'BGD', 'name_en' => 'Bangladesh', 'name_fr' => 'Bangladesh'],
            ['id' => '16', 'code' => '51', 'alpha2' => 'AM', 'alpha3' => 'ARM', 'name_en' => 'Armenia', 'name_fr' => 'Arménie'],
            ['id' => '17', 'code' => '52', 'alpha2' => 'BB', 'alpha3' => 'BRB', 'name_en' => 'Barbados', 'name_fr' => 'Barbade'],
            ['id' => '18', 'code' => '56', 'alpha2' => 'BE', 'alpha3' => 'BEL', 'name_en' => 'Belgium', 'name_fr' => 'Belgique'],
            ['id' => '19', 'code' => '60', 'alpha2' => 'BM', 'alpha3' => 'BMU', 'name_en' => 'Bermuda', 'name_fr' => 'Bermudes'],
            ['id' => '20', 'code' => '64', 'alpha2' => 'BT', 'alpha3' => 'BTN', 'name_en' => 'Bhutan', 'name_fr' => 'Bhoutan'],
            ['id' => '21', 'code' => '68', 'alpha2' => 'BO', 'alpha3' => 'BOL', 'name_en' => 'Bolivia', 'name_fr' => 'Bolivie'],
            ['id' => '22', 'code' => '70', 'alpha2' => 'BA', 'alpha3' => 'BIH', 'name_en' => 'Bosnia and Herzegovina', 'name_fr' => 'Bosnie-Herzégovine'],
            ['id' => '23', 'code' => '72', 'alpha2' => 'BW', 'alpha3' => 'BWA', 'name_en' => 'Botswana', 'name_fr' => 'Botswana'],
            ['id' => '24', 'code' => '74', 'alpha2' => 'BV', 'alpha3' => 'BVT', 'name_en' => 'Bouvet Island', 'name_fr' => 'Île Bouvet'],
            ['id' => '25', 'code' => '76', 'alpha2' => 'BR', 'alpha3' => 'BRA', 'name_en' => 'Brazil', 'name_fr' => 'Brésil'],
            ['id' => '26', 'code' => '84', 'alpha2' => 'BZ', 'alpha3' => 'BLZ', 'name_en' => 'Belize', 'name_fr' => 'Belize'],
            ['id' => '27', 'code' => '86', 'alpha2' => 'IO', 'alpha3' => 'IOT', 'name_en' => 'British Indian Ocean Territory', 'name_fr' => 'Territoire Britannique de l\'Océan Indien'],
            ['id' => '28', 'code' => '90', 'alpha2' => 'SB', 'alpha3' => 'SLB', 'name_en' => 'Solomon Islands', 'name_fr' => 'Îles Salomon'],
            ['id' => '29', 'code' => '92', 'alpha2' => 'VG', 'alpha3' => 'VGB', 'name_en' => 'British Virgin Islands', 'name_fr' => 'Îles Vierges Britanniques'],
            ['id' => '30', 'code' => '96', 'alpha2' => 'BN', 'alpha3' => 'BRN', 'name_en' => 'Brunei Darussalam', 'name_fr' => 'Brunéi Darussalam'],
            ['id' => '31', 'code' => '100', 'alpha2' => 'BG', 'alpha3' => 'BGR', 'name_en' => 'Bulgaria', 'name_fr' => 'Bulgarie'],
            ['id' => '32', 'code' => '104', 'alpha2' => 'MM', 'alpha3' => 'MMR', 'name_en' => 'Myanmar', 'name_fr' => 'Myanmar'],
            ['id' => '33', 'code' => '108', 'alpha2' => 'BI', 'alpha3' => 'BDI', 'name_en' => 'Burundi', 'name_fr' => 'Burundi'],
            ['id' => '34', 'code' => '112', 'alpha2' => 'BY', 'alpha3' => 'BLR', 'name_en' => 'Belarus', 'name_fr' => 'Bélarus'],
            ['id' => '35', 'code' => '116', 'alpha2' => 'KH', 'alpha3' => 'KHM', 'name_en' => 'Cambodia', 'name_fr' => 'Cambodge'],
            ['id' => '36', 'code' => '120', 'alpha2' => 'CM', 'alpha3' => 'CMR', 'name_en' => 'Cameroon', 'name_fr' => 'Cameroun'],
            ['id' => '37', 'code' => '124', 'alpha2' => 'CA', 'alpha3' => 'CAN', 'name_en' => 'Canada', 'name_fr' => 'Canada'],
            ['id' => '38', 'code' => '132', 'alpha2' => 'CV', 'alpha3' => 'CPV', 'name_en' => 'Cape Verde', 'name_fr' => 'Cap-vert'],
            ['id' => '39', 'code' => '136', 'alpha2' => 'KY', 'alpha3' => 'CYM', 'name_en' => 'Cayman Islands', 'name_fr' => 'Îles Caïmanes'],
            ['id' => '40', 'code' => '140', 'alpha2' => 'CF', 'alpha3' => 'CAF', 'name_en' => 'Central African', 'name_fr' => 'République Centrafricaine'],
            ['id' => '41', 'code' => '144', 'alpha2' => 'LK', 'alpha3' => 'LKA', 'name_en' => 'Sri Lanka', 'name_fr' => 'Sri Lanka'],
            ['id' => '42', 'code' => '148', 'alpha2' => 'TD', 'alpha3' => 'TCD', 'name_en' => 'Chad', 'name_fr' => 'Tchad'],
            ['id' => '43', 'code' => '152', 'alpha2' => 'CL', 'alpha3' => 'CHL', 'name_en' => 'Chile', 'name_fr' => 'Chili'],
            ['id' => '44', 'code' => '156', 'alpha2' => 'CN', 'alpha3' => 'CHN', 'name_en' => 'China', 'name_fr' => 'Chine'],
            ['id' => '45', 'code' => '158', 'alpha2' => 'TW', 'alpha3' => 'TWN', 'name_en' => 'Taiwan', 'name_fr' => 'Taïwan'],
            ['id' => '46', 'code' => '162', 'alpha2' => 'CX', 'alpha3' => 'CXR', 'name_en' => 'Christmas Island', 'name_fr' => 'Île Christmas'],
            ['id' => '47', 'code' => '166', 'alpha2' => 'CC', 'alpha3' => 'CCK', 'name_en' => 'Cocos (Keeling) Islands', 'name_fr' => 'Îles Cocos (Keeling)'],
            ['id' => '48', 'code' => '170', 'alpha2' => 'CO', 'alpha3' => 'COL', 'name_en' => 'Colombia', 'name_fr' => 'Colombie'],
            ['id' => '49', 'code' => '174', 'alpha2' => 'KM', 'alpha3' => 'COM', 'name_en' => 'Comoros', 'name_fr' => 'Comores'],
            ['id' => '50', 'code' => '175', 'alpha2' => 'YT', 'alpha3' => 'MYT', 'name_en' => 'Mayotte', 'name_fr' => 'Mayotte'],
            ['id' => '51', 'code' => '178', 'alpha2' => 'CG', 'alpha3' => 'COG', 'name_en' => 'Republic of the Congo', 'name_fr' => 'République du Congo'],
            ['id' => '52', 'code' => '180', 'alpha2' => 'CD', 'alpha3' => 'COD', 'name_en' => 'The Democratic Republic Of The Congo', 'name_fr' => 'République Démocratique du Congo'],
            ['id' => '53', 'code' => '184', 'alpha2' => 'CK', 'alpha3' => 'COK', 'name_en' => 'Cook Islands', 'name_fr' => 'Îles Cook'],
            ['id' => '54', 'code' => '188', 'alpha2' => 'CR', 'alpha3' => 'CRI', 'name_en' => 'Costa Rica', 'name_fr' => 'Costa Rica'],
            ['id' => '55', 'code' => '191', 'alpha2' => 'HR', 'alpha3' => 'HRV', 'name_en' => 'Croatia', 'name_fr' => 'Croatie'],
            ['id' => '56', 'code' => '192', 'alpha2' => 'CU', 'alpha3' => 'CUB', 'name_en' => 'Cuba', 'name_fr' => 'Cuba'],
            ['id' => '57', 'code' => '196', 'alpha2' => 'CY', 'alpha3' => 'CYP', 'name_en' => 'Cyprus', 'name_fr' => 'Chypre'],
            ['id' => '58', 'code' => '203', 'alpha2' => 'CZ', 'alpha3' => 'CZE', 'name_en' => 'Czech Republic', 'name_fr' => 'République Tchèque'],
            ['id' => '59', 'code' => '204', 'alpha2' => 'BJ', 'alpha3' => 'BEN', 'name_en' => 'Benin', 'name_fr' => 'Bénin'],
            ['id' => '60', 'code' => '208', 'alpha2' => 'DK', 'alpha3' => 'DNK', 'name_en' => 'Denmark', 'name_fr' => 'Danemark'],
            ['id' => '61', 'code' => '212', 'alpha2' => 'DM', 'alpha3' => 'DMA', 'name_en' => 'Dominica', 'name_fr' => 'Dominique'],
            ['id' => '62', 'code' => '214', 'alpha2' => 'DO', 'alpha3' => 'DOM', 'name_en' => 'Dominican Republic', 'name_fr' => 'République Dominicaine'],
            ['id' => '63', 'code' => '218', 'alpha2' => 'EC', 'alpha3' => 'ECU', 'name_en' => 'Ecuador', 'name_fr' => 'Équateur'],
            ['id' => '64', 'code' => '222', 'alpha2' => 'SV', 'alpha3' => 'SLV', 'name_en' => 'El Salvador', 'name_fr' => 'El Salvador'],
            ['id' => '65', 'code' => '226', 'alpha2' => 'GQ', 'alpha3' => 'GNQ', 'name_en' => 'Equatorial Guinea', 'name_fr' => 'Guinée Équatoriale'],
            ['id' => '66', 'code' => '231', 'alpha2' => 'ET', 'alpha3' => 'ETH', 'name_en' => 'Ethiopia', 'name_fr' => 'Éthiopie'],
            ['id' => '67', 'code' => '232', 'alpha2' => 'ER', 'alpha3' => 'ERI', 'name_en' => 'Eritrea', 'name_fr' => 'Érythrée'],
            ['id' => '68', 'code' => '233', 'alpha2' => 'EE', 'alpha3' => 'EST', 'name_en' => 'Estonia', 'name_fr' => 'Estonie'],
            ['id' => '69', 'code' => '234', 'alpha2' => 'FO', 'alpha3' => 'FRO', 'name_en' => 'Faroe Islands', 'name_fr' => 'Îles Féroé'],
            ['id' => '70', 'code' => '238', 'alpha2' => 'FK', 'alpha3' => 'FLK', 'name_en' => 'Falkland Islands', 'name_fr' => 'Îles (malvinas) Falkland'],
            ['id' => '71', 'code' => '239', 'alpha2' => 'GS', 'alpha3' => 'SGS', 'name_en' => 'South Georgia and the South Sandwich Islands', 'name_fr' => 'Géorgie du Sud et les Îles Sandwich du Sud'],
            ['id' => '72', 'code' => '242', 'alpha2' => 'FJ', 'alpha3' => 'FJI', 'name_en' => 'Fiji', 'name_fr' => 'Fidji'],
            ['id' => '73', 'code' => '246', 'alpha2' => 'FI', 'alpha3' => 'FIN', 'name_en' => 'Finland', 'name_fr' => 'Finlande'],
            ['id' => '74', 'code' => '248', 'alpha2' => 'AX', 'alpha3' => 'ALA', 'name_en' => 'Åland Islands', 'name_fr' => 'Îles Åland'],
            ['id' => '75', 'code' => '250', 'alpha2' => 'FR', 'alpha3' => 'FRA', 'name_en' => 'France', 'name_fr' => 'France'],
            ['id' => '76', 'code' => '254', 'alpha2' => 'GF', 'alpha3' => 'GUF', 'name_en' => 'French Guiana', 'name_fr' => 'Guyane Française'],
            ['id' => '77', 'code' => '258', 'alpha2' => 'PF', 'alpha3' => 'PYF', 'name_en' => 'French Polynesia', 'name_fr' => 'Polynésie Française'],
            ['id' => '78', 'code' => '260', 'alpha2' => 'TF', 'alpha3' => 'ATF', 'name_en' => 'French Southern Territories', 'name_fr' => 'Terres Australes Françaises'],
            ['id' => '79', 'code' => '262', 'alpha2' => 'DJ', 'alpha3' => 'DJI', 'name_en' => 'Djibouti', 'name_fr' => 'Djibouti'],
            ['id' => '80', 'code' => '266', 'alpha2' => 'GA', 'alpha3' => 'GAB', 'name_en' => 'Gabon', 'name_fr' => 'Gabon'],
            ['id' => '81', 'code' => '268', 'alpha2' => 'GE', 'alpha3' => 'GEO', 'name_en' => 'Georgia', 'name_fr' => 'Géorgie'],
            ['id' => '82', 'code' => '270', 'alpha2' => 'GM', 'alpha3' => 'GMB', 'name_en' => 'Gambia', 'name_fr' => 'Gambie'],
            ['id' => '83', 'code' => '275', 'alpha2' => 'PS', 'alpha3' => 'PSE', 'name_en' => 'Occupied Palestinian Territory', 'name_fr' => 'Territoire Palestinien Occupé'],
            ['id' => '84', 'code' => '276', 'alpha2' => 'DE', 'alpha3' => 'DEU', 'name_en' => 'Germany', 'name_fr' => 'Allemagne'],
            ['id' => '85', 'code' => '288', 'alpha2' => 'GH', 'alpha3' => 'GHA', 'name_en' => 'Ghana', 'name_fr' => 'Ghana'],
            ['id' => '86', 'code' => '292', 'alpha2' => 'GI', 'alpha3' => 'GIB', 'name_en' => 'Gibraltar', 'name_fr' => 'Gibraltar'],
            ['id' => '87', 'code' => '296', 'alpha2' => 'KI', 'alpha3' => 'KIR', 'name_en' => 'Kiribati', 'name_fr' => 'Kiribati'],
            ['id' => '88', 'code' => '300', 'alpha2' => 'GR', 'alpha3' => 'GRC', 'name_en' => 'Greece', 'name_fr' => 'Grèce'],
            ['id' => '89', 'code' => '304', 'alpha2' => 'GL', 'alpha3' => 'GRL', 'name_en' => 'Greenland', 'name_fr' => 'Groenland'],
            ['id' => '90', 'code' => '308', 'alpha2' => 'GD', 'alpha3' => 'GRD', 'name_en' => 'Grenada', 'name_fr' => 'Grenade'],
            ['id' => '91', 'code' => '312', 'alpha2' => 'GP', 'alpha3' => 'GLP', 'name_en' => 'Guadeloupe', 'name_fr' => 'Guadeloupe'],
            ['id' => '92', 'code' => '316', 'alpha2' => 'GU', 'alpha3' => 'GUM', 'name_en' => 'Guam', 'name_fr' => 'Guam'],
            ['id' => '93', 'code' => '320', 'alpha2' => 'GT', 'alpha3' => 'GTM', 'name_en' => 'Guatemala', 'name_fr' => 'Guatemala'],
            ['id' => '94', 'code' => '324', 'alpha2' => 'GN', 'alpha3' => 'GIN', 'name_en' => 'Guinea', 'name_fr' => 'Guinée'],
            ['id' => '95', 'code' => '328', 'alpha2' => 'GY', 'alpha3' => 'GUY', 'name_en' => 'Guyana', 'name_fr' => 'Guyana'],
            ['id' => '96', 'code' => '332', 'alpha2' => 'HT', 'alpha3' => 'HTI', 'name_en' => 'Haiti', 'name_fr' => 'Haïti'],
            ['id' => '97', 'code' => '334', 'alpha2' => 'HM', 'alpha3' => 'HMD', 'name_en' => 'Heard Island and McDonald Islands', 'name_fr' => 'Îles Heard et Mcdonald'],
            ['id' => '98', 'code' => '336', 'alpha2' => 'VA', 'alpha3' => 'VAT', 'name_en' => 'Vatican City State', 'name_fr' => 'Saint-Siège (état de la Cité du Vatican)'],
            ['id' => '99', 'code' => '340', 'alpha2' => 'HN', 'alpha3' => 'HND', 'name_en' => 'Honduras', 'name_fr' => 'Honduras'],
            ['id' => '100', 'code' => '344', 'alpha2' => 'HK', 'alpha3' => 'HKG', 'name_en' => 'Hong Kong', 'name_fr' => 'Hong-Kong'],
            ['id' => '101', 'code' => '348', 'alpha2' => 'HU', 'alpha3' => 'HUN', 'name_en' => 'Hungary', 'name_fr' => 'Hongrie'],
            ['id' => '102', 'code' => '352', 'alpha2' => 'IS', 'alpha3' => 'ISL', 'name_en' => 'Iceland', 'name_fr' => 'Islande'],
            ['id' => '103', 'code' => '356', 'alpha2' => 'IN', 'alpha3' => 'IND', 'name_en' => 'India', 'name_fr' => 'Inde'],
            ['id' => '104', 'code' => '360', 'alpha2' => 'ID', 'alpha3' => 'IDN', 'name_en' => 'Indonesia', 'name_fr' => 'Indonésie'],
            ['id' => '105', 'code' => '364', 'alpha2' => 'IR', 'alpha3' => 'IRN', 'name_en' => 'Islamic Republic of Iran', 'name_fr' => 'République Islamique d\'Iran'],
            ['id' => '106', 'code' => '368', 'alpha2' => 'IQ', 'alpha3' => 'IRQ', 'name_en' => 'Iraq', 'name_fr' => 'Iraq'],
            ['id' => '107', 'code' => '372', 'alpha2' => 'IE', 'alpha3' => 'IRL', 'name_en' => 'Ireland', 'name_fr' => 'Irlande'],
            ['id' => '109', 'code' => '380', 'alpha2' => 'IT', 'alpha3' => 'ITA', 'name_en' => 'Italy', 'name_fr' => 'Italie'],
            ['id' => '110', 'code' => '384', 'alpha2' => 'CI', 'alpha3' => 'CIV', 'name_en' => 'Côte d\'Ivoire', 'name_fr' => 'Côte d\'Ivoire'],
            ['id' => '111', 'code' => '388', 'alpha2' => 'JM', 'alpha3' => 'JAM', 'name_en' => 'Jamaica', 'name_fr' => 'Jamaïque'],
            ['id' => '112', 'code' => '392', 'alpha2' => 'JP', 'alpha3' => 'JPN', 'name_en' => 'Japan', 'name_fr' => 'Japon'],
            ['id' => '113', 'code' => '398', 'alpha2' => 'KZ', 'alpha3' => 'KAZ', 'name_en' => 'Kazakhstan', 'name_fr' => 'Kazakhstan'],
            ['id' => '114', 'code' => '400', 'alpha2' => 'JO', 'alpha3' => 'JOR', 'name_en' => 'Jordan', 'name_fr' => 'Jordanie'],
            ['id' => '115', 'code' => '404', 'alpha2' => 'KE', 'alpha3' => 'KEN', 'name_en' => 'Kenya', 'name_fr' => 'Kenya'],
            ['id' => '116', 'code' => '408', 'alpha2' => 'KP', 'alpha3' => 'PRK', 'name_en' => 'Democratic People\'s Republic of Korea', 'name_fr' => 'République Populaire Démocratique de Corée'],
            ['id' => '117', 'code' => '410', 'alpha2' => 'KR', 'alpha3' => 'KOR', 'name_en' => 'Republic of Korea', 'name_fr' => 'République de Corée'],
            ['id' => '118', 'code' => '414', 'alpha2' => 'KW', 'alpha3' => 'KWT', 'name_en' => 'Kuwait', 'name_fr' => 'Koweït'],
            ['id' => '119', 'code' => '417', 'alpha2' => 'KG', 'alpha3' => 'KGZ', 'name_en' => 'Kyrgyzstan', 'name_fr' => 'Kirghizistan'],
            ['id' => '120', 'code' => '418', 'alpha2' => 'LA', 'alpha3' => 'LAO', 'name_en' => 'Lao People\'s Democratic Republic', 'name_fr' => 'République Démocratique Populaire Lao'],
            ['id' => '121', 'code' => '422', 'alpha2' => 'LB', 'alpha3' => 'LBN', 'name_en' => 'Lebanon', 'name_fr' => 'Liban'],
            ['id' => '122', 'code' => '426', 'alpha2' => 'LS', 'alpha3' => 'LSO', 'name_en' => 'Lesotho', 'name_fr' => 'Lesotho'],
            ['id' => '123', 'code' => '428', 'alpha2' => 'LV', 'alpha3' => 'LVA', 'name_en' => 'Latvia', 'name_fr' => 'Lettonie'],
            ['id' => '124', 'code' => '430', 'alpha2' => 'LR', 'alpha3' => 'LBR', 'name_en' => 'Liberia', 'name_fr' => 'Libéria'],
            ['id' => '125', 'code' => '434', 'alpha2' => 'LY', 'alpha3' => 'LBY', 'name_en' => 'Libyan Arab Jamahiriya', 'name_fr' => 'Jamahiriya Arabe Libyenne'],
            ['id' => '126', 'code' => '438', 'alpha2' => 'LI', 'alpha3' => 'LIE', 'name_en' => 'Liechtenstein', 'name_fr' => 'Liechtenstein'],
            ['id' => '127', 'code' => '440', 'alpha2' => 'LT', 'alpha3' => 'LTU', 'name_en' => 'Lithuania', 'name_fr' => 'Lituanie'],
            ['id' => '128', 'code' => '442', 'alpha2' => 'LU', 'alpha3' => 'LUX', 'name_en' => 'Luxembourg', 'name_fr' => 'Luxembourg'],
            ['id' => '129', 'code' => '446', 'alpha2' => 'MO', 'alpha3' => 'MAC', 'name_en' => 'Macao', 'name_fr' => 'Macao'],
            ['id' => '130', 'code' => '450', 'alpha2' => 'MG', 'alpha3' => 'MDG', 'name_en' => 'Madagascar', 'name_fr' => 'Madagascar'],
            ['id' => '131', 'code' => '454', 'alpha2' => 'MW', 'alpha3' => 'MWI', 'name_en' => 'Malawi', 'name_fr' => 'Malawi'],
            ['id' => '132', 'code' => '458', 'alpha2' => 'MY', 'alpha3' => 'MYS', 'name_en' => 'Malaysia', 'name_fr' => 'Malaisie'],
            ['id' => '133', 'code' => '462', 'alpha2' => 'MV', 'alpha3' => 'MDV', 'name_en' => 'Maldives', 'name_fr' => 'Maldives'],
            ['id' => '134', 'code' => '466', 'alpha2' => 'ML', 'alpha3' => 'MLI', 'name_en' => 'Mali', 'name_fr' => 'Mali'],
            ['id' => '135', 'code' => '470', 'alpha2' => 'MT', 'alpha3' => 'MLT', 'name_en' => 'Malta', 'name_fr' => 'Malte'],
            ['id' => '136', 'code' => '474', 'alpha2' => 'MQ', 'alpha3' => 'MTQ', 'name_en' => 'Martinique', 'name_fr' => 'Martinique'],
            ['id' => '137', 'code' => '478', 'alpha2' => 'MR', 'alpha3' => 'MRT', 'name_en' => 'Mauritania', 'name_fr' => 'Mauritanie'],
            ['id' => '138', 'code' => '480', 'alpha2' => 'MU', 'alpha3' => 'MUS', 'name_en' => 'Mauritius', 'name_fr' => 'Maurice'],
            ['id' => '139', 'code' => '484', 'alpha2' => 'MX', 'alpha3' => 'MEX', 'name_en' => 'Mexico', 'name_fr' => 'Mexique'],
            ['id' => '140', 'code' => '492', 'alpha2' => 'MC', 'alpha3' => 'MCO', 'name_en' => 'Monaco', 'name_fr' => 'Monaco'],
            ['id' => '141', 'code' => '496', 'alpha2' => 'MN', 'alpha3' => 'MNG', 'name_en' => 'Mongolia', 'name_fr' => 'Mongolie'],
            ['id' => '142', 'code' => '498', 'alpha2' => 'MD', 'alpha3' => 'MDA', 'name_en' => 'Republic of Moldova', 'name_fr' => 'République de Moldova'],
            ['id' => '143', 'code' => '500', 'alpha2' => 'MS', 'alpha3' => 'MSR', 'name_en' => 'Montserrat', 'name_fr' => 'Montserrat'],
            ['id' => '144', 'code' => '504', 'alpha2' => 'MA', 'alpha3' => 'MAR', 'name_en' => 'Morocco', 'name_fr' => 'Maroc'],
            ['id' => '145', 'code' => '508', 'alpha2' => 'MZ', 'alpha3' => 'MOZ', 'name_en' => 'Mozambique', 'name_fr' => 'Mozambique'],
            ['id' => '146', 'code' => '512', 'alpha2' => 'OM', 'alpha3' => 'OMN', 'name_en' => 'Oman', 'name_fr' => 'Oman'],
            ['id' => '147', 'code' => '516', 'alpha2' => 'NA', 'alpha3' => 'NAM', 'name_en' => 'Namibia', 'name_fr' => 'Namibie'],
            ['id' => '148', 'code' => '520', 'alpha2' => 'NR', 'alpha3' => 'NRU', 'name_en' => 'Nauru', 'name_fr' => 'Nauru'],
            ['id' => '149', 'code' => '524', 'alpha2' => 'NP', 'alpha3' => 'NPL', 'name_en' => 'Nepal', 'name_fr' => 'Népal'],
            ['id' => '150', 'code' => '528', 'alpha2' => 'NL', 'alpha3' => 'NLD', 'name_en' => 'Netherlands', 'name_fr' => 'Pays-Bas'],
            ['id' => '151', 'code' => '530', 'alpha2' => 'AN', 'alpha3' => 'ANT', 'name_en' => 'Netherlands Antilles', 'name_fr' => 'Antilles Néerlandaises'],
            ['id' => '152', 'code' => '533', 'alpha2' => 'AW', 'alpha3' => 'ABW', 'name_en' => 'Aruba', 'name_fr' => 'Aruba'],
            ['id' => '153', 'code' => '540', 'alpha2' => 'NC', 'alpha3' => 'NCL', 'name_en' => 'New Caledonia', 'name_fr' => 'Nouvelle-Calédonie'],
            ['id' => '154', 'code' => '548', 'alpha2' => 'VU', 'alpha3' => 'VUT', 'name_en' => 'Vanuatu', 'name_fr' => 'Vanuatu'],
            ['id' => '155', 'code' => '554', 'alpha2' => 'NZ', 'alpha3' => 'NZL', 'name_en' => 'New Zealand', 'name_fr' => 'Nouvelle-Zélande'],
            ['id' => '156', 'code' => '558', 'alpha2' => 'NI', 'alpha3' => 'NIC', 'name_en' => 'Nicaragua', 'name_fr' => 'Nicaragua'],
            ['id' => '157', 'code' => '562', 'alpha2' => 'NE', 'alpha3' => 'NER', 'name_en' => 'Niger', 'name_fr' => 'Niger'],
            ['id' => '158', 'code' => '566', 'alpha2' => 'NG', 'alpha3' => 'NGA', 'name_en' => 'Nigeria', 'name_fr' => 'Nigéria'],
            ['id' => '159', 'code' => '570', 'alpha2' => 'NU', 'alpha3' => 'NIU', 'name_en' => 'Niue', 'name_fr' => 'Niué'],
            ['id' => '160', 'code' => '574', 'alpha2' => 'NF', 'alpha3' => 'NFK', 'name_en' => 'Norfolk Island', 'name_fr' => 'Île Norfolk'],
            ['id' => '161', 'code' => '578', 'alpha2' => 'NO', 'alpha3' => 'NOR', 'name_en' => 'Norway', 'name_fr' => 'Norvège'],
            ['id' => '162', 'code' => '580', 'alpha2' => 'MP', 'alpha3' => 'MNP', 'name_en' => 'Northern Mariana Islands', 'name_fr' => 'Îles Mariannes du Nord'],
            ['id' => '163', 'code' => '581', 'alpha2' => 'UM', 'alpha3' => 'UMI', 'name_en' => 'United States Minor Outlying Islands', 'name_fr' => 'Îles Mineures Éloignées des États-Unis'],
            ['id' => '164', 'code' => '583', 'alpha2' => 'FM', 'alpha3' => 'FSM', 'name_en' => 'Federated States of Micronesia', 'name_fr' => 'États Fédérés de Micronésie'],
            ['id' => '165', 'code' => '584', 'alpha2' => 'MH', 'alpha3' => 'MHL', 'name_en' => 'Marshall Islands', 'name_fr' => 'Îles Marshall'],
            ['id' => '166', 'code' => '585', 'alpha2' => 'PW', 'alpha3' => 'PLW', 'name_en' => 'Palau', 'name_fr' => 'Palaos'],
            ['id' => '167', 'code' => '586', 'alpha2' => 'PK', 'alpha3' => 'PAK', 'name_en' => 'Pakistan', 'name_fr' => 'Pakistan'],
            ['id' => '168', 'code' => '591', 'alpha2' => 'PA', 'alpha3' => 'PAN', 'name_en' => 'Panama', 'name_fr' => 'Panama'],
            ['id' => '169', 'code' => '598', 'alpha2' => 'PG', 'alpha3' => 'PNG', 'name_en' => 'Papua New Guinea', 'name_fr' => 'Papouasie-Nouvelle-Guinée'],
            ['id' => '170', 'code' => '600', 'alpha2' => 'PY', 'alpha3' => 'PRY', 'name_en' => 'Paraguay', 'name_fr' => 'Paraguay'],
            ['id' => '171', 'code' => '604', 'alpha2' => 'PE', 'alpha3' => 'PER', 'name_en' => 'Peru', 'name_fr' => 'Pérou'],
            ['id' => '172', 'code' => '608', 'alpha2' => 'PH', 'alpha3' => 'PHL', 'name_en' => 'Philippines', 'name_fr' => 'Philippines'],
            ['id' => '173', 'code' => '612', 'alpha2' => 'PN', 'alpha3' => 'PCN', 'name_en' => 'Pitcairn', 'name_fr' => 'Pitcairn'],
            ['id' => '174', 'code' => '616', 'alpha2' => 'PL', 'alpha3' => 'POL', 'name_en' => 'Poland', 'name_fr' => 'Pologne'],
            ['id' => '175', 'code' => '620', 'alpha2' => 'PT', 'alpha3' => 'PRT', 'name_en' => 'Portugal', 'name_fr' => 'Portugal'],
            ['id' => '176', 'code' => '624', 'alpha2' => 'GW', 'alpha3' => 'GNB', 'name_en' => 'Guinea-Bissau', 'name_fr' => 'Guinée-Bissau'],
            ['id' => '177', 'code' => '626', 'alpha2' => 'TL', 'alpha3' => 'TLS', 'name_en' => 'Timor-Leste', 'name_fr' => 'Timor-Leste'],
            ['id' => '178', 'code' => '630', 'alpha2' => 'PR', 'alpha3' => 'PRI', 'name_en' => 'Puerto Rico', 'name_fr' => 'Porto Rico'],
            ['id' => '179', 'code' => '634', 'alpha2' => 'QA', 'alpha3' => 'QAT', 'name_en' => 'Qatar', 'name_fr' => 'Qatar'],
            ['id' => '180', 'code' => '638', 'alpha2' => 'RE', 'alpha3' => 'REU', 'name_en' => 'Réunion', 'name_fr' => 'Réunion'],
            ['id' => '181', 'code' => '642', 'alpha2' => 'RO', 'alpha3' => 'ROU', 'name_en' => 'Romania', 'name_fr' => 'Roumanie'],
            ['id' => '182', 'code' => '643', 'alpha2' => 'RU', 'alpha3' => 'RUS', 'name_en' => 'Russian Federation', 'name_fr' => 'Fédération de Russie'],
            ['id' => '183', 'code' => '646', 'alpha2' => 'RW', 'alpha3' => 'RWA', 'name_en' => 'Rwanda', 'name_fr' => 'Rwanda'],
            ['id' => '184', 'code' => '654', 'alpha2' => 'SH', 'alpha3' => 'SHN', 'name_en' => 'Saint Helena', 'name_fr' => 'Sainte-Hélène'],
            ['id' => '185', 'code' => '659', 'alpha2' => 'KN', 'alpha3' => 'KNA', 'name_en' => 'Saint Kitts and Nevis', 'name_fr' => 'Saint-Kitts-et-Nevis'],
            ['id' => '186', 'code' => '660', 'alpha2' => 'AI', 'alpha3' => 'AIA', 'name_en' => 'Anguilla', 'name_fr' => 'Anguilla'],
            ['id' => '187', 'code' => '662', 'alpha2' => 'LC', 'alpha3' => 'LCA', 'name_en' => 'Saint Lucia', 'name_fr' => 'Sainte-Lucie'],
            ['id' => '188', 'code' => '666', 'alpha2' => 'PM', 'alpha3' => 'SPM', 'name_en' => 'Saint-Pierre and Miquelon', 'name_fr' => 'Saint-Pierre-et-Miquelon'],
            ['id' => '189', 'code' => '670', 'alpha2' => 'VC', 'alpha3' => 'VCT', 'name_en' => 'Saint Vincent and the Grenadines', 'name_fr' => 'Saint-Vincent-et-les Grenadines'],
            ['id' => '190', 'code' => '674', 'alpha2' => 'SM', 'alpha3' => 'SMR', 'name_en' => 'San Marino', 'name_fr' => 'Saint-Marin'],
            ['id' => '191', 'code' => '678', 'alpha2' => 'ST', 'alpha3' => 'STP', 'name_en' => 'Sao Tome and Principe', 'name_fr' => 'Sao Tomé-et-Principe'],
            ['id' => '192', 'code' => '682', 'alpha2' => 'SA', 'alpha3' => 'SAU', 'name_en' => 'Saudi Arabia', 'name_fr' => 'Arabie Saoudite'],
            ['id' => '193', 'code' => '686', 'alpha2' => 'SN', 'alpha3' => 'SEN', 'name_en' => 'Senegal', 'name_fr' => 'Sénégal'],
            ['id' => '194', 'code' => '690', 'alpha2' => 'SC', 'alpha3' => 'SYC', 'name_en' => 'Seychelles', 'name_fr' => 'Seychelles'],
            ['id' => '195', 'code' => '694', 'alpha2' => 'SL', 'alpha3' => 'SLE', 'name_en' => 'Sierra Leone', 'name_fr' => 'Sierra Leone'],
            ['id' => '196', 'code' => '702', 'alpha2' => 'SG', 'alpha3' => 'SGP', 'name_en' => 'Singapore', 'name_fr' => 'Singapour'],
            ['id' => '197', 'code' => '703', 'alpha2' => 'SK', 'alpha3' => 'SVK', 'name_en' => 'Slovakia', 'name_fr' => 'Slovaquie'],
            ['id' => '198', 'code' => '704', 'alpha2' => 'VN', 'alpha3' => 'VNM', 'name_en' => 'Vietnam', 'name_fr' => 'Viet Nam'],
            ['id' => '199', 'code' => '705', 'alpha2' => 'SI', 'alpha3' => 'SVN', 'name_en' => 'Slovenia', 'name_fr' => 'Slovénie'],
            ['id' => '200', 'code' => '706', 'alpha2' => 'SO', 'alpha3' => 'SOM', 'name_en' => 'Somalia', 'name_fr' => 'Somalie'],
            ['id' => '201', 'code' => '710', 'alpha2' => 'ZA', 'alpha3' => 'ZAF', 'name_en' => 'South Africa', 'name_fr' => 'Afrique du Sud'],
            ['id' => '202', 'code' => '716', 'alpha2' => 'ZW', 'alpha3' => 'ZWE', 'name_en' => 'Zimbabwe', 'name_fr' => 'Zimbabwe'],
            ['id' => '203', 'code' => '724', 'alpha2' => 'ES', 'alpha3' => 'ESP', 'name_en' => 'Spain', 'name_fr' => 'Espagne'],
            ['id' => '204', 'code' => '732', 'alpha2' => 'EH', 'alpha3' => 'ESH', 'name_en' => 'Western Sahara', 'name_fr' => 'Sahara Occidental'],
            ['id' => '205', 'code' => '736', 'alpha2' => 'SD', 'alpha3' => 'SDN', 'name_en' => 'Sudan', 'name_fr' => 'Soudan'],
            ['id' => '206', 'code' => '740', 'alpha2' => 'SR', 'alpha3' => 'SUR', 'name_en' => 'Suriname', 'name_fr' => 'Suriname'],
            ['id' => '207', 'code' => '744', 'alpha2' => 'SJ', 'alpha3' => 'SJM', 'name_en' => 'Svalbard and Jan Mayen', 'name_fr' => 'Svalbard etÎle Jan Mayen'],
            ['id' => '208', 'code' => '748', 'alpha2' => 'SZ', 'alpha3' => 'SWZ', 'name_en' => 'Swaziland', 'name_fr' => 'Swaziland'],
            ['id' => '209', 'code' => '752', 'alpha2' => 'SE', 'alpha3' => 'SWE', 'name_en' => 'Sweden', 'name_fr' => 'Suède'],
            ['id' => '210', 'code' => '756', 'alpha2' => 'CH', 'alpha3' => 'CHE', 'name_en' => 'Switzerland', 'name_fr' => 'Suisse'],
            ['id' => '211', 'code' => '760', 'alpha2' => 'SY', 'alpha3' => 'SYR', 'name_en' => 'Syrian Arab Republic', 'name_fr' => 'République Arabe Syrienne'],
            ['id' => '212', 'code' => '762', 'alpha2' => 'TJ', 'alpha3' => 'TJK', 'name_en' => 'Tajikistan', 'name_fr' => 'Tadjikistan'],
            ['id' => '213', 'code' => '764', 'alpha2' => 'TH', 'alpha3' => 'THA', 'name_en' => 'Thailand', 'name_fr' => 'Thaïlande'],
            ['id' => '214', 'code' => '768', 'alpha2' => 'TG', 'alpha3' => 'TGO', 'name_en' => 'Togo', 'name_fr' => 'Togo'],
            ['id' => '215', 'code' => '772', 'alpha2' => 'TK', 'alpha3' => 'TKL', 'name_en' => 'Tokelau', 'name_fr' => 'Tokelau'],
            ['id' => '216', 'code' => '776', 'alpha2' => 'TO', 'alpha3' => 'TON', 'name_en' => 'Tonga', 'name_fr' => 'Tonga'],
            ['id' => '217', 'code' => '780', 'alpha2' => 'TT', 'alpha3' => 'TTO', 'name_en' => 'Trinidad and Tobago', 'name_fr' => 'Trinité-et-Tobago'],
            ['id' => '218', 'code' => '784', 'alpha2' => 'AE', 'alpha3' => 'ARE', 'name_en' => 'United Arab Emirates', 'name_fr' => 'Émirats Arabes Unis'],
            ['id' => '219', 'code' => '788', 'alpha2' => 'TN', 'alpha3' => 'TUN', 'name_en' => 'Tunisia', 'name_fr' => 'Tunisie'],
            ['id' => '220', 'code' => '792', 'alpha2' => 'TR', 'alpha3' => 'TUR', 'name_en' => 'Turkey', 'name_fr' => 'Turquie'],
            ['id' => '221', 'code' => '795', 'alpha2' => 'TM', 'alpha3' => 'TKM', 'name_en' => 'Turkmenistan', 'name_fr' => 'Turkménistan'],
            ['id' => '222', 'code' => '796', 'alpha2' => 'TC', 'alpha3' => 'TCA', 'name_en' => 'Turks and Caicos Islands', 'name_fr' => 'Îles Turks et Caïques'],
            ['id' => '223', 'code' => '798', 'alpha2' => 'TV', 'alpha3' => 'TUV', 'name_en' => 'Tuvalu', 'name_fr' => 'Tuvalu'],
            ['id' => '224', 'code' => '800', 'alpha2' => 'UG', 'alpha3' => 'UGA', 'name_en' => 'Uganda', 'name_fr' => 'Ouganda'],
            ['id' => '225', 'code' => '804', 'alpha2' => 'UA', 'alpha3' => 'UKR', 'name_en' => 'Ukraine', 'name_fr' => 'Ukraine'],
            ['id' => '226', 'code' => '807', 'alpha2' => 'MK', 'alpha3' => 'MKD', 'name_en' => 'The Former Yugoslav Republic of Macedonia', 'name_fr' => 'L\'ex-République Yougoslave de Macédoine'],
            ['id' => '227', 'code' => '818', 'alpha2' => 'EG', 'alpha3' => 'EGY', 'name_en' => 'Egypt', 'name_fr' => 'Égypte'],
            ['id' => '228', 'code' => '826', 'alpha2' => 'GB', 'alpha3' => 'GBR', 'name_en' => 'United Kingdom', 'name_fr' => 'Royaume-Uni'],
            ['id' => '229', 'code' => '833', 'alpha2' => 'IM', 'alpha3' => 'IMN', 'name_en' => 'Isle of Man', 'name_fr' => 'Île de Man'],
            ['id' => '230', 'code' => '834', 'alpha2' => 'TZ', 'alpha3' => 'TZA', 'name_en' => 'United Republic Of Tanzania', 'name_fr' => 'République-Unie de Tanzanie'],
            ['id' => '231', 'code' => '840', 'alpha2' => 'US', 'alpha3' => 'USA', 'name_en' => 'United States', 'name_fr' => 'États-Unis'],
            ['id' => '232', 'code' => '850', 'alpha2' => 'VI', 'alpha3' => 'VIR', 'name_en' => 'U.S. Virgin Islands', 'name_fr' => 'Îles Vierges des États-Unis'],
            ['id' => '233', 'code' => '854', 'alpha2' => 'BF', 'alpha3' => 'BFA', 'name_en' => 'Burkina Faso', 'name_fr' => 'Burkina Faso'],
            ['id' => '234', 'code' => '858', 'alpha2' => 'UY', 'alpha3' => 'URY', 'name_en' => 'Uruguay', 'name_fr' => 'Uruguay'],
            ['id' => '235', 'code' => '860', 'alpha2' => 'UZ', 'alpha3' => 'UZB', 'name_en' => 'Uzbekistan', 'name_fr' => 'Ouzbékistan'],
            ['id' => '236', 'code' => '862', 'alpha2' => 'VE', 'alpha3' => 'VEN', 'name_en' => 'Venezuela', 'name_fr' => 'Venezuela'],
            ['id' => '237', 'code' => '876', 'alpha2' => 'WF', 'alpha3' => 'WLF', 'name_en' => 'Wallis and Futuna', 'name_fr' => 'Wallis et Futuna'],
            ['id' => '238', 'code' => '882', 'alpha2' => 'WS', 'alpha3' => 'WSM', 'name_en' => 'Samoa', 'name_fr' => 'Samoa'],
            ['id' => '239', 'code' => '887', 'alpha2' => 'YE', 'alpha3' => 'YEM', 'name_en' => 'Yemen', 'name_fr' => 'Yémen'],
            ['id' => '240', 'code' => '891', 'alpha2' => 'CS', 'alpha3' => 'SCG', 'name_en' => 'Serbia and Montenegro', 'name_fr' => 'Serbie-et-Monténégro'],
            ['id' => '241', 'code' => '894', 'alpha2' => 'ZM', 'alpha3' => 'ZMB', 'name_en' => 'Zambia', 'name_fr' => 'Zambie']
        ];

        DB::table('countries')->delete();
        Country::insert($countries);
        $this->command->info('Countries table seeding end');
    }
}
