<?php

use App\Models\Category;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CategoriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->command->info('Categories table seeding start');
        $data = [

            ['id' => 1 , 'parent_id' => 0 , 'name' => "Détection - Mesure" , 'level' => 0],
            ['id' => 2 , 'parent_id' => 0 , 'name' => "Métrologie - Laboratoire" , 'level' => 0],
            ['id' => 3 , 'parent_id' => 0 , 'name' => "Robotique - Automatisme - Informatique" , 'level' => 0],
            ['id' => 4 , 'parent_id' => 0 , 'name' => "Électricité - Électronique - Optique" , 'level' => 0],
            ['id' => 5 , 'parent_id' => 0 , 'name' => "Mécanique - Transmission de puissance" , 'level' => 0],
            ['id' => 6 , 'parent_id' => 0 , 'name' => "Hydraulique - Pneumatique" , 'level' => 0],
            ['id' => 7 , 'parent_id' => 0 , 'name' => "Matériaux - Outillage - Composants" , 'level' => 0],
            ['id' => 8 , 'parent_id' => 0 , 'name' => "Machines-Outils" , 'level' => 0],
            ['id' => 9 , 'parent_id' => 0 , 'name' => "Machines de production" , 'level' => 0],
            ['id' => 10 , 'parent_id' => 0 , 'name' => "Machines et équipements industriels" , 'level' => 0],
            ['id' => 11 , 'parent_id' => 0 , 'name' => "Emballage - Logistique - Manutention" , 'level' => 0],
            ['id' => 12 , 'parent_id' => 0 , 'name' => "Hygiène - Sécurité - Environnement" , 'level' => 0],
            ['id' => 13 , 'parent_id' => 0 , 'name' => "Bâtiment - Travaux" , 'level' => 0],


            ['id' => 14 , 'parent_id' => 1 , 'name' => "Mesure de débit, Pression et niveau", 'level' => 1],
            ['id' => 15 , 'parent_id' => 1 , 'name' => "Mesure de température et humidité", 'level' => 1],
            ['id' => 16 , 'parent_id' => 1 , 'name' => "Mesure de position, Vitesse et accélération", 'level' => 1],
            ['id' => 17 , 'parent_id' => 1 , 'name' => "Mesure de force", 'level' => 1],
            ['id' => 18 , 'parent_id' => 1 , 'name' => "Mesure acoustique et optique", 'level' => 1],
            ['id' => 19 , 'parent_id' => 1 , 'name' => "Mesure électrique", 'level' => 1],

            ['id' => 20 , 'parent_id' => 2 , 'name' => "Analyse physico-chimique", 'level' => 1],
            ['id' => 21 , 'parent_id' => 2 , 'name' => "Métrologie et essais", 'level' => 1],
            ['id' => 22 , 'parent_id' => 2 , 'name' => "Inspection et surveillance", 'level' => 1],
            ['id' => 23 , 'parent_id' => 2 , 'name' => "Équipement de laboratoire", 'level' => 1],

            ['id' => 24 , 'parent_id' => 3 , 'name' => "Automatisme", 'level' => 1],
            ['id' => 25 , 'parent_id' => 3 , 'name' => "Robotique industrielle", 'level' => 1],
            ['id' => 26 , 'parent_id' => 3 , 'name' => "Robotique de service", 'level' => 1],
            ['id' => 27 , 'parent_id' => 3 , 'name' => "Informatique : Hardware", 'level' => 1],
            ['id' => 28 , 'parent_id' => 3 , 'name' => "Informatique : logiciels", 'level' => 1],

            ['id' => 29 , 'parent_id' => 4 , 'name' => "Production et distribution d'énergie", 'level' => 1],
            ['id' => 30 , 'parent_id' => 4 , 'name' => "Alimentation électrique", 'level' => 1],
            ['id' => 31 , 'parent_id' => 4 , 'name' => "Interrupteurs et relais", 'level' => 1],
            ['id' => 32 , 'parent_id' => 4 , 'name' => "Câbles, Connecteurs et Boîtiers", 'level' => 1],
            ['id' => 33 , 'parent_id' => 4 , 'name' => "Composants électroniques", 'level' => 1],
            ['id' => 34 , 'parent_id' => 4 , 'name' => "composants optiques", 'level' => 1],

            ['id' => 35 , 'parent_id' => 5 , 'name' => "Moteurs et contrôle moteur", 'level' => 1],
            ['id' => 36 , 'parent_id' => 5 , 'name' => "Roulements et guidages linéaires", 'level' => 1],
            ['id' => 37 , 'parent_id' => 5 , 'name' => "Transmission mécanique", 'level' => 1],
            ['id' => 38 , 'parent_id' => 5 , 'name' => "Actionneurs et positionnement", 'level' => 1],

            ['id' => 39 , 'parent_id' => 6 , 'name' => "Pompes", 'level' => 1],
            ['id' => 40 , 'parent_id' => 6 , 'name' => "Compresseurs", 'level' => 1],
            ['id' => 41 , 'parent_id' => 6 , 'name' => "Actionneurs hydrauliques et pneumatiques", 'level' => 1],
            ['id' => 42 , 'parent_id' => 6 , 'name' => "Vannes et électrovannes", 'level' => 1],
            ['id' => 43 , 'parent_id' => 6 , 'name' => "Tuyauterie et raccords", 'level' => 1],
            ['id' => 44 , 'parent_id' => 6 , 'name' => "Filtres et séparateurs", 'level' => 1],

            ['id' => 45 , 'parent_id' => 7 , 'name' => "Produits semi-finis", 'level' => 1],
            ['id' => 46 , 'parent_id' => 7 , 'name' => "Lubrification", 'level' => 1],
            ['id' => 47 , 'parent_id' => 7 , 'name' => "Outillage", 'level' => 1],
            ['id' => 48 , 'parent_id' => 7 , 'name' => "Eléments mécaniques standards", 'level' => 1],

            ['id' => 49 , 'parent_id' => 8 , 'name' => "Machines d'usinage", 'level' => 1],
            ['id' => 50 , 'parent_id' => 8 , 'name' => "Machines de finition", 'level' => 1],
            ['id' => 51 , 'parent_id' => 8 , 'name' => "Outils de coupe", 'level' => 1],
            ['id' => 52 , 'parent_id' => 8 , 'name' => "Équipements pour machines outils", 'level' => 1],

            ['id' => 53 , 'parent_id' => 9 , 'name' => "Machines textiles", 'level' => 1],
            ['id' => 54 , 'parent_id' => 9 , 'name' => "Plasturgie", 'level' => 1],
            ['id' => 55 , 'parent_id' => 9 , 'name' => "Machines de découpe", 'level' => 1],
            ['id' => 56 , 'parent_id' => 9 , 'name' => "Machines de formage", 'level' => 1],
            ['id' => 57 , 'parent_id' => 9 , 'name' => "Machines de production agro-alimentaire", 'level' => 1],
            ['id' => 58 , 'parent_id' => 9 , 'name' => "Autres machines industrielles", 'level' => 1],

            ['id' => 59 , 'parent_id' => 10 , 'name' => "Traitement de surface", 'level' => 1],
            ['id' => 60 , 'parent_id' => 10 , 'name' => "Soudage, Vissage et Collage", 'level' => 1],
            ['id' => 61 , 'parent_id' => 10 , 'name' => "Impression, Marquage et Gravage", 'level' => 1],
            ['id' => 62 , 'parent_id' => 10 , 'name' => "Fours et traitement thermique", 'level' => 1],
            ['id' => 63 , 'parent_id' => 10 , 'name' => "Échangeurs de chaleur et froid industriel", 'level' => 1],
            ['id' => 64 , 'parent_id' => 10 , 'name' => "Mélange et dosage", 'level' => 1],

            ['id' => 65 , 'parent_id' => 11 , 'name' => "Conditionnement et emballage", 'level' => 1],
            ['id' => 66 , 'parent_id' => 11 , 'name' => "Manutention et levage", 'level' => 1],
            ['id' => 67 , 'parent_id' => 11 , 'name' => "Convoyage", 'level' => 1],
            ['id' => 68 , 'parent_id' => 11 , 'name' => "stockage", 'level' => 1],

            ['id' => 69 , 'parent_id' => 12 , 'name' => "Traitement de l'air et gestion du bruit", 'level' => 1],
            ['id' => 70 , 'parent_id' => 12 , 'name' => "Traitement de l'eau", 'level' => 1],
            ['id' => 71 , 'parent_id' => 12 , 'name' => "Traitement des déchets", 'level' => 1],
            ['id' => 72 , 'parent_id' => 12 , 'name' => "Équipement de protection individuelle", 'level' => 1],
            ['id' => 73 , 'parent_id' => 12 , 'name' => "Sécurité des machines et des locaux", 'level' => 1],

            ['id' => 74 , 'parent_id' => 13 , 'name' => "Aménagement des bâtiments industriels", 'level' => 1],
            ['id' => 75 , 'parent_id' => 13 , 'name' => "Engins et matériels pour chantiers et mines", 'level' => 1],



            ['id' => 76 , 'parent_id' => 14 , 'name' => "Capteurs de débit", 'level' => 2],
            ['id' => 77 , 'parent_id' => 14 , 'name' => "Transmetteurs de débit", 'level' => 2],
            ['id' => 78 , 'parent_id' => 14 , 'name' => "Contrôleurs de débit", 'level' => 2],
            ['id' => 79 , 'parent_id' => 14 , 'name' => "Débitmètres", 'level' => 2],
            ['id' => 80 , 'parent_id' => 14 , 'name' => "Compteurs volumétriques", 'level' => 2],
            ['id' => 81 , 'parent_id' => 14 , 'name' => "Accessoires pour débitmètres", 'level' => 2],
            ['id' => 82 , 'parent_id' => 14 , 'name' => "Capteurs de pression", 'level' => 2],
            ['id' => 83 , 'parent_id' => 14 , 'name' => "Transducteurs de pression", 'level' => 2],
            ['id' => 84 , 'parent_id' => 14 , 'name' => "Transmetteurs de pression", 'level' => 2],
            ['id' => 85 , 'parent_id' => 14 , 'name' => "Pressostats", 'level' => 2],
            ['id' => 86 , 'parent_id' => 14 , 'name' => "Jauges à vide", 'level' => 2],
            ['id' => 87 , 'parent_id' => 14 , 'name' => "Manomètres", 'level' => 2],
            ['id' => 88 , 'parent_id' => 14 , 'name' => "Séparateurs à membrane", 'level' => 2],
            ['id' => 89 , 'parent_id' => 14 , 'name' => "Calibrateurs de pression", 'level' => 2],
            ['id' => 90 , 'parent_id' => 14 , 'name' => "Détecteurs de fuites", 'level' => 2],
            ['id' => 91 , 'parent_id' => 14 , 'name' => "Testeurs d'étanchéité", 'level' => 2],
            ['id' => 92 , 'parent_id' => 14 , 'name' => "Autres instruments de mesure de pression", 'level' => 2],
            ['id' => 93 , 'parent_id' => 14 , 'name' => "Détecteurs de niveau", 'level' => 2],
            ['id' => 94 , 'parent_id' => 14 , 'name' => "Capteurs de niveau", 'level' => 2],
            ['id' => 95 , 'parent_id' => 14 , 'name' => "Transmetteurs de niveau", 'level' => 2],
            ['id' => 96 , 'parent_id' => 14 , 'name' => "Jauges de niveau", 'level' => 2],

            ['id' => 97 , 'parent_id' => 15 , 'name' => "Capteurs de température", 'level' => 2],
            ['id' => 98 , 'parent_id' => 15 , 'name' => "Thermistances", 'level' => 2],
            ['id' => 99 , 'parent_id' => 15 , 'name' => "Thermocouples", 'level' => 2],
            ['id' => 100, 'parent_id' => 15 , 'name' => "Transmetteurs de température", 'level' => 2],
            ['id' => 101, 'parent_id' => 15 , 'name' => "Accessoires pour capteurs de température", 'level' => 2],
            ['id' => 102, 'parent_id' => 15 , 'name' => "Thermostats", 'level' => 2],
            ['id' => 103, 'parent_id' => 15 , 'name' => "Capteurs d'humidité", 'level' => 2],
            ['id' => 104, 'parent_id' => 15 , 'name' => "Hygromètres", 'level' => 2],
            ['id' => 105, 'parent_id' => 15 , 'name' => "Anémomètres", 'level' => 2],
            ['id' => 106, 'parent_id' => 15 , 'name' => "Autres instruments de mesure météorologiques", 'level' => 2],
            ['id' => 107, 'parent_id' => 15 , 'name' => "Thermomètres", 'level' => 2],
            ['id' => 108, 'parent_id' => 15 , 'name' => "Indicateurs de température", 'level' => 2],
            ['id' => 109, 'parent_id' => 15 , 'name' => "Caméras d'imagerie thermique", 'level' => 2],
            ['id' => 110, 'parent_id' => 15 , 'name' => "Calibrateurs de température", 'level' => 2],
            ['id' => 111, 'parent_id' => 15 , 'name' => "Calibrateurs multifonctions, autres calibrateurs", 'level' => 2],


        ];

        DB::table('categories')->delete();
        Category::insert($data);
        $categories = Category::all();
        foreach ($categories as $category) {
            $category->slug = str_slug($category->name);
            $category->save();
        }
        $this->command->info('Categories table seeding end');
    }
}
