<?php

use App\Models\BrandCategory;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BrandCategoriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->command->info('Brand Categories table seeding start');
        $data = [

            ['id' => 1, 'name' => "Producteur"],
            ['id' => 2, 'name' => "Importateur"],
            ['id' => 3, 'name' => "Distributeur / Revendeur"],
            ['id' => 4, 'name' => "Prestataire / Installateur "],
        ];

        DB::table('brand_categories')->delete();
        BrandCategory::insert($data);

        $this->command->info('Brand Categories table seeding end');
    }
}
