<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAttributesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('attributes', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('category_id')->nullable();
            $table->string('name')->nullable();
            $table->string('type')->nullable();
            $table->text('default_value')->nullable();
            $table->text('value')->nullable();
            $table->boolean('multi_value')->nullable()->default(0);
            $table->boolean('required')->nullable()->default(0);
            $table->boolean('filtrable')->nullable()->default(0);
            $table->string('unite')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('attributes');
    }
}
