<?php

/*
|--------------------------------------------------------------------------
| Model Factories
|--------------------------------------------------------------------------
|
| Here you may define all of your model factories. Model factories give
| you a convenient way to create models for testing and seeding your
| database. Just tell the factory how a default model should look.
|
*/

/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\User::class, function (Faker\Generator $faker) {
    static $password;

    return [
        'name'              => $faker->name,
        'email'             => $faker->unique()->safeEmail,
        'password'          => $password ?: $password = bcrypt('secret'),
        'remember_token'    => str_random(10),
        'role_id'           => 2,
        'company_id'        => $faker->numberBetween(1, 100)
    ];
});

$factory->define(App\Models\Company::class, function (Faker\Generator $faker) {
    $company_name = $faker->sentence(2);
    return [
        'name'          => $company_name,
        'slug'          => str_slug($company_name),
        'description'   => $faker->paragraph(4),
        //'values'        => $faker->paragraph(4),
        'image'         => "logo-placeholder.jpg",
        'email'         => $faker->companyEmail,
        'phone'         => $faker->phoneNumber,
        'mobile'        => $faker->phoneNumber,
        'fax'           => $faker->phoneNumber,
        'adresse'       => $faker->address(),
        'site'          => $faker->url(),
        'prenom'        => $faker->name,
        'nom'           => $faker->name,
        'country_id'    => $faker->numberBetween(1, 5),

    ];
});

$factory->define(App\Models\Brand::class, function(Faker\Generator $faker) {
    $brand_name = $faker->sentence(2);
    return [
        'name'          => $brand_name,
        'slug'          => str_slug($brand_name),
        'description'   => $faker->paragraph(4),
        'logo'          => "marque-placeholder.png"
    ];
});

$factory->define(App\Models\Product::class, function (Faker\Generator $faker) {
    return [
        'name'          => $faker->sentence(4),
        'ref'           => $faker->word,
        'code_douanier' => $faker->word,
        'brand_id'      => $faker->numberBetween(1, 100),
        'description'   => $faker->paragraph(4),
        'category_id'   => $faker->randomElement([76, 77]),
        'company_id'    => $faker->numberBetween(1, 100),
        'image'         => "no-photo.jpg"
    ];
});

$factory->define(App\Models\Place::class, function (Faker\Generator $faker) {
    return [
        'name'          => $faker->sentence(4),
        'image'         => "no-photo.jpg",
        'lat'           => '36.773113', //$faker->latitude(),
        'long'          => '3.059977', //$faker->longitude(),
        'company_id'    => $faker->numberBetween(1, 100),
        'email'         => $faker->companyEmail,
        'phone'         => $faker->phoneNumber,
        'mobile'        => $faker->phoneNumber,
        'fax'           => $faker->phoneNumber,
        'adresse'       => $faker->address(),
        'ville'         => $faker->city,
        'country_id'    => $faker->numberBetween(1, 5),
    ];
});

$factory->define(App\Models\Trend::class, function (Faker\Generator $faker) {
    $trend_name = $faker->sentence(4);
    return [
        'name'                  => $trend_name,
        'slug'                  => str_slug($trend_name),
        'adresse'               => $faker->address(),
        'description'           => $faker->paragraph(10),
        'link'                  => $faker->url(),
        'company_id'            => $faker->numberBetween(1, 100),
        'trend_category_id'     => $faker->numberBetween(1, 5),
        'image'                 => "no-photo.jpg"
    ];
});

$factory->define(App\Models\TrendAssociation::class, function (Faker\Generator $faker) {
    return [
        'trend_id'              => $faker->numberBetween(1, 400),
        'associated_id'         => $faker->numberBetween(1, 400),
        'type'                  => $faker->randomElement(['trend', 'product'])
    ];
});


$factory->define(App\Models\Catalogue::class, function (Faker\Generator $faker) {
    $catalogue_name = $faker->sentence(4);
    return [
        'name'          => $catalogue_name,
        'slug'          => str_slug($catalogue_name),
        'number_pages'  => $faker->numberBetween(20, 60),
        'filename'      => '',
        'category_id'   => $faker->numberBetween(1, 13),
        'brand_id'    => $faker->numberBetween(1, 100),
        'image'         => "no-photo.jpg",
        'number_views'  => $faker->numberBetween(1, 400),
        'archive'       => $faker->randomElement([0, 1])
    ];
});

$factory->define(App\Models\Project::class, function (Faker\Generator $faker) {
    $project_name = $faker->sentence(4);
    return [
        'name'                  => $project_name,
        'slug'                  => str_slug($project_name),
        'adresse'               => $faker->address(),
        'description'           => $faker->paragraph(10),
        'link'                  => $faker->url(),
        'company_id'            => $faker->numberBetween(1, 100),
        'project_category_id'   => $faker->numberBetween(1, 5),
        'image'                 => "no-photo.jpg"
    ];
});

$factory->define(App\Models\ProjectAssociation::class, function (Faker\Generator $faker) {
    return [
        'project_id'            => $faker->numberBetween(1, 400),
        'associated_id'          => $faker->numberBetween(1, 400),
        'type'                  => $faker->randomElement(['project', 'product'])
    ];
});

$factory->define(App\Models\Salon::class, function (Faker\Generator $faker) {
    $date_start = $faker->dateTimeBetween('+10 days', '+6 month');
    $date_end =  date('Y-m-d', strtotime($date_start->format('Y-m-d'). ' + 3 days'));
    $salon_name = $faker->sentence(4);
    return [
        'name'                  => $salon_name,
        'slug'                  => str_slug($salon_name),
        'date_start'            => $date_start->format('Y-m-d'),
        'date_end'              => $date_end,
        'ville'                 => $faker->city,
        'country_id'            => $faker->numberBetween(1, 5),
        'link'                  => $faker->url(),
        'company_id'            => $faker->numberBetween(1, 100),
        'image'                 => "no-photo.jpg",
        'confirmed'             => $faker->randomElement([0, 1])
    ];
});
