<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Models\TrendCategory
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $slug
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Trend[] $trends
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\TrendCategory whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\TrendCategory whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\TrendCategory whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\TrendCategory whereSlug($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\TrendCategory whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class TrendCategory extends Model
{
    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function trends()
    {
        return $this->hasMany(Trend::class, 'trend_category_id');
    }
}
