<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

/**
 * App\Models\Trend
 *
 * @property int $id
 * @property string $name
 * @property string|null $slug
 * @property string|null $adresse
 * @property string|null $description
 * @property string|null $link
 * @property int|null $company_id
 * @property int|null $trend_category_id
 * @property string|null $image
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @property-read \App\Models\TrendCategory|null $category
 * @property-read \App\Models\Company|null $company
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Trend search($search, $threshold = null, $entireText = false, $entireTextOnly = false)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Trend searchRestricted($search, $restriction, $threshold = null, $entireText = false, $entireTextOnly = false)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Trend whereAdresse($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Trend whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Trend whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Trend whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Trend whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Trend whereImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Trend whereLink($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Trend whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Trend whereSlug($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Trend whereTrendCategoryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Trend whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Trend extends Model
{
    protected $guarded = [];

    use SearchableTrait;

    protected $searchable = [
        'columns' => [
            'trends.name' => 10,
            'trends.description' => 8,
            'trends.adresse' => 5,
            'trend_categories.name' =>8
        ], 'joins' => [
            'trend_categories' => ['trend_categories.id','trends.trend_category_id'],
        ],
    ];

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function category()
    {
        return $this->belongsTo(TrendCategory::class, 'trend_category_id');
    }

    public function scopeClient($query)
    {
        return $query->where('company_id', auth()->user()->company_id);
    }
}
