<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Nicolaslopezj\Searchable\SearchableTrait;


/**
 * App\Models\Product
 *
 * @property int $id
 * @property string $name
 * @property string|null $slug
 * @property string $ref
 * @property string|null $description
 * @property int|null $category_id
 * @property int|null $company_id
 * @property string|null $image
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @property-read \App\Models\Category|null $category
 * @property-read \App\Models\Company|null $company
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Product search($search, $threshold = null, $entireText = false, $entireTextOnly = false)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Product searchRestricted($search, $restriction, $threshold = null, $entireText = false, $entireTextOnly = false)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Product whereCategoryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Product whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Product whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Product whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Product whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Product whereImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Product whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Product whereRef($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Product whereSlug($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Product whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Product extends Model
{
    use SearchableTrait;

    protected $guarded = [];

    protected $searchable = [
        'columns' => [
            'products.name' => 10,
            'products.description' => 8,
            'products.ref' => 5,
            'products.code_douanier' => 5,
            'categories.name' => 8,
            'brands.name' => 8,
        ], 'joins' => [
            'categories' => ['categories.id','products.category_id'],
            'brands'    => ['brands.id','products.brand_id']
        ],
    ];

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function companies()
    {
        return $this->belongsToMany(Company::class);
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }


    public function scopeClient($query)
    {
        return $query->where('company_id', auth()->user()->company_id);
    }

    public function attributes()
    {
        return $this->hasMany(ProductAttribute::class);
    }

    public function scopePublished($query)
    {
        return $query->wherePublished(true);
    }
}
