<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

/**
 * App\Models\Place
 *
 * @property int $id
 * @property string $name
 * @property string|null $adresse
 * @property string|null $photo
 * @property string|null $lat
 * @property string|null $long
 * @property int|null $company_id
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Place whereAdresse($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Place whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Place whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Place whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Place whereLat($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Place whereLong($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Place whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Place wherePhoto($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Place whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Place extends Model
{

    use SearchableTrait;

    protected $guarded = [];

    protected $searchable = [
        'columns' => [
            'name'      => 10,
            'adresse'   => 9,
            'email'     => 7
        ]
    ];

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function scopeClient($query)
    {
        return $query->where('company_id', auth()->user()->company_id);
    }
}
