<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class Brand extends Model
{
    use SearchableTrait;

    protected $guarded = [];

    protected $searchable = [
        'columns' => [
            'brands.name' => 10,
            'brands.description' => 8
        ]
    ];

    public function products()
    {
        return $this->hasMany(Product::class, 'brand_id');
    }

    public function categories()
    {
        $products_cat = Product::where('brand_id', $this->id)->distinct()->pluck('category_id')->all();
        $categories = Category::whereIn('id', $products_cat)->get();
        return $categories;
    }

    public function dislay_logo()
    {
        //return $this->logo;
        return '<img src="' .  $this->logo  . '" style="width: 80px;">';
    }

    public function catalogues()
    {
        return $this->hasMany(Catalogue::class);
    }

    public function category()
    {
        return $this->belongsTo(BrandCategory::class, 'category_id');
    }

    public function getLogoLinkAttribute($value)
    {
        return asset('storage/brands/' . $this->logo);
    }
}
