<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Catalogue;
use App\Models\Category;
use App\Models\Country;
use App\Models\Product;
use App\Models\Project;
use App\Models\Trend;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Inscription;
use Illuminate\Http\Response;

class HomeController extends Controller
{
    /**
     * Show the application dashboard.
     *
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $query = !empty($request->get('q')) ? $request->get('q') : null;
        $type = !empty($request->get('type')) ? $request->get('type') : null;
        // $product_count = Product::published()->whereHas('company',  function($query) {
        //     $query->wherePublished(true);
        // })->count();
        $product_count = Product::published()->count();

        if ($query) {
            $products = Product::published()->search($query, null, true)->with('category')->paginate(36);
            return view('frontend.products.index', compact('products', 'product_count', 'query', 'type'));
        } else {
            $categories = Category::with('subs')->where('parent_id', 0)->get();
            $last_products = Product::published()->with('category', 'brand')->orderBy('created_at', 'desc')->get()->take(6);
            $last_projects = Project::with('category')->orderBy('created_at', 'desc')->get()->take(4);
            $last_trends = Trend::with('category')->orderBy('created_at', 'desc')->get()->take(4);

            return view('frontend.home', compact('categories', 'product_count', 'last_products', 'last_projects', 'last_trends', 'query', 'type'));
        }
    }

    public function demandeProduits(Product $product)
    {
        return view('frontend.demandes.produits.index', compact('product'));
    }

    public function demandeProduitsSend(Request $request, Product $product)
    {
        //dd($request->input());
        return redirect()->back();
    }

    public function demandeCatalogues(Catalogue $catalogue)
    {
        return view('frontend.demandes.catalogues.index', compact('catalogue'));
    }

    public function demandeCataloguesSend(Request $request, Catalogue $catalogue)
    {
        //dd($request->input());
        return redirect()->back();
    }


    public function exposant()
    {
        $categories = Category::where('level', 2)->pluck('name', 'id');
        $countries = Country::pluck('name_fr', 'id');
        return view('frontend.exposants.index', compact('categories', 'countries'));
    }

    public function exposantStore(Request $request)
    {
        $inscription = Inscription::create($request->input());

        return redirect()->route('exposant.confirm');
    }

    public function exposantConfirm()
    {
        return view('frontend.exposants.confirm');
    }


    public function categoriesSelect(Request $request, $id)
    {
        $category = Category::findOrFail($id);
        $level = $request->get('level');
        // if($category->level == 0) {
        //     $categories = Category::with('subs')->where('parent_id', $id)->pluck('name', 'id');
        // }else{
        //     $categories = Category::with('subs')->where('parent_id', $id)->pluck('name', 'slug');
        // }
        $categories = Category::with('subs')->where('parent_id', $id)->pluck('name', 'id');
        return view('frontend._select', compact('categories', 'level'));
    }

    public function categoriesAutocomplete(Request $request)
    {
        $query = !empty($request->get('q')) ? $request->get('q') : null;
        $categories = Category::search($query, null, true)->with('subs')->where('level', 2)->pluck('name', 'slug');

        return view('frontend.search.autocomplete', compact('categories'));
        
    }
}
