<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Company;
use App\Models\Product;
use App\Models\Project;
use App\Models\Salon;
use App\Models\Trend;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CompanyController extends Controller
{
    public function index(Company $company)
    {
        //$produits =Product::published()->with(['category', 'brand'])->where('company_id', $company->id)->get();
        return view('frontend.companies.produits', compact('company'));
    }

    public function show(Company $company)
    {
        return view('frontend.companies.show', compact('company'));
    }

    public function productShow(Company $company, Product $product)
    {
        return view('frontend.companies.products.show', compact('company', 'product'));
    }

    public function places(Company $company)
    {
        return view('frontend.places', compact('company'));
    }

    public function trends(Company $company)
    {
        $trends = Trend::where('company_id', $company->id)->get();
        return view('frontend.companies.trends', compact('company', 'trends'));
    }

    public function projects(Company $company)
    {
        $projects = Project::where('company_id', $company->id)->get();
        return view('frontend.companies.projects', compact('company', 'projects'));
    }

    public function salons(Company $company)
    {
        $salons = Salon::where('company_id', $company->id)->get();
        return view('frontend.companies.salons', compact('company', 'salons'));
    }

}
