<?php

namespace App\Http\Controllers\Frontend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Brand;
use App\Models\Catalogue;
use App\Models\Product;

class BrandController extends Controller
{
    public function index(Brand $brand)
    {
        return view('frontend.brands.produits', compact('brand'));
    }

    public function productShow(Brand $brand, Product $product)
    {
        return view('frontend.products.show', compact('brand', 'product'));
    }

    public function catalogues(Brand $brand)
    {
        $catalogues = Catalogue::where('brand_id', $brand->id)->get();
        return view('frontend.brands.catalogues', compact('brand', 'catalogues'));
    }
}
