<?php

namespace App\Http\Controllers\Client;

use App\Models\Catalogue;
use App\Models\Category;
use App\Models\CompanyCategory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;


class CatalogueController extends Controller
{
    public function index(Request $request)
    {
        $query = !empty($request->get('q')) ? $request->get('q') : null;
        if($query) {
            $catalogues = Catalogue::Client()->with('category')->search($query, null, true)->paginate(20);
        }else{
            $catalogues = Catalogue::Client()->with('category')->paginate(20);
        }
        return view('clients.catalogues.index', compact('catalogues'));
    }

    public function create()
    {
        $selected_ids = CompanyCategory::where("company_id", auth()->user()->company_id)->pluck('category_id')->all();
        $categories = Category::with('parent')->whereIN('id', $selected_ids)->pluck('name', 'id');

        return view('clients.catalogues.create', compact('categories'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'file' => 'mimes:pdf'
        ],[
            'mimes' => 'Le catalogue doit être au format pdf'
        ]);


        $catalogue = Catalogue::Client()->create($request->input());
        $catalogue->company_id = auth()->user()->company_id;
        $catalogue->slug = str_slug($request->input('name'), '-');
        $catalogue->save();
        if( $request->hasFile('file') ) {
            $file = $request->file('file');
            $path = 'public/companies/'. $catalogue->company_id . '/catalogues/';
            $path = $request->file('file')->storeAs($path, $file->getClientOriginalName());
            $catalogue->filename = $file->getClientOriginalName();
            $catalogue->save();
        }

        return redirect()->route('clients.catalogues.show', $catalogue->id );
    }

    public function show($id)
    {
        $catalogue = Catalogue::Client()->findOrFail($id);
        return view('clients.catalogues.show', compact('catalogue'));
    }

    public function edit($id)
    {
        $selected_ids = CompanyCategory::where("company_id", auth()->user()->company_id)->pluck('category_id')->all();
        $categories = Category::with('parent')->whereIN('id', $selected_ids)->pluck('name', 'id');

        $catalogue = Catalogue::Client()->findOrFail($id);
        return view('clients.catalogues.edit', compact('catalogue', 'categories'));
    }

    public function update(Request $request, $id)
    {
        $catalogue = Catalogue::Client()->findOrFail($id);
        $catalogue->fill($request->input());
        $catalogue->save();

        if( $request->hasFile('file') ) {
            // Delete old file
            $path = 'public/companies/'. $catalogue->company_id . '/catalogues/' . $catalogue->filename;
            if(File::exists(storage_path('app/' . $path))) {
                Storage::delete($path);
            }
            // Upload new file
            $file = $request->file('file');
            $path = 'public/companies/'. $catalogue->company_id . '/catalogues/';
            $path = $request->file('file')->storeAs($path, $file->getClientOriginalName());
            $catalogue->filename = $file->getClientOriginalName();
            $catalogue->save();
        }

        return redirect()->route('clients.catalogues.show', $catalogue->id );
    }

    public function delete($id)
    {

        $catalogue = Catalogue::Client()->findOrFail($id);
        $path = 'public/companies/'. $catalogue->company_id . '/catalogues/' . $catalogue->filename;
        Storage::delete($path);
        $catalogue->delete();

        return redirect()->route('clients.catalogues.index');
    }
}
