<?php

namespace App\Http\Controllers\Backend;

use App\Models\Catalogue;
use App\Models\Company;
use App\Models\Brand;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;


class CatalogueController extends Controller
{
    public function index(Request $request)
    {
        $query = !empty($request->get('q')) ? $request->get('q') : null;
        $company = !empty($request->get('company')) ? $request->get('company') : null;
        $cataloguesQuery = Catalogue::with(['category']);
        if($query) {
            $cataloguesQuery = $cataloguesQuery->search($query, null, true);
        }
        if($company) {
            $cataloguesQuery = $cataloguesQuery->where('company_id', $company);
        }
        $catalogues = $cataloguesQuery->paginate(20);
        $companies = Company::pluck('name', 'id');
        return view('backend.catalogues.index', compact('catalogues', 'companies'));
    }

    public function create()
    {
        //$companies = Company::pluck('name', 'id');
        $brands = Brand::pluck('name', 'id');
        return view('backend.catalogues.create', compact('brands'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'file' => 'mimes:pdf'
        ],[
            'mimes' => 'Le catalogue doit être au format pdf'
        ]);


        $catalogue = Catalogue::create($request->input());
        $catalogue->slug = str_slug($request->input('name'), '-');
        $catalogue->save();
        if( $request->hasFile('file') ) {
            $file = $request->file('file');
            $path = 'public/companies/'. $catalogue->company_id . '/catalogues/';
            $path = $request->file('file')->storeAs($path, $file->getClientOriginalName());
            $catalogue->filename = $file->getClientOriginalName();
            $catalogue->save();
        }

        return redirect()->route('backend.catalogues.show', $catalogue->id );
    }

    public function show($id)
    {
        $catalogue = Catalogue::findOrFail($id);
        return view('backend.catalogues.show', compact('catalogue'));
    }

    public function edit($id)
    {
        $catalogue = Catalogue::findOrFail($id);
        $companies = Company::pluck('name', 'id');
        return view('backend.catalogues.edit', compact('catalogue', 'companies'));
    }

    public function update(Request $request, $id)
    {
        $catalogue = Catalogue::findOrFail($id);
        $catalogue->fill($request->input());
        $catalogue->save();

        if( $request->hasFile('file') ) {
            // Delete old file
            $path = 'public/companies/'. $catalogue->company_id . '/catalogues/' . $catalogue->filename;
            if(File::exists(storage_path('app/' . $path))) {
                Storage::delete($path);
            }
            // Upload new file
            $file = $request->file('file');
            $path = 'public/companies/'. $catalogue->company_id . '/catalogues/';
            $path = $request->file('file')->storeAs($path, $file->getClientOriginalName());
            $catalogue->filename = $file->getClientOriginalName();
            $catalogue->save();
        }

        return redirect()->route('backend.catalogues.show', $catalogue->id );
    }

    public function delete($id)
    {

        $catalogue = Catalogue::findOrFail($id);
        $path = 'public/companies/'. $catalogue->company_id . '/catalogues/' . $catalogue->filename;
        Storage::delete($path);
        $catalogue->delete();

        return redirect()->route('backend.catalogues.index');
    }
}
