<?php

namespace App\Http\Controllers\Backend;

use App\Models\Trend;
use App\Models\TrendCategory;
use App\Models\Company;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class TrendController extends Controller
{
    public function index(Request $request)
    {
        $query = !empty($request->get('q')) ? $request->get('q') : null;
        $company = !empty($request->get('company')) ? $request->get('company') : null;
        $trendsQuery = Trend::with(['category', 'company']);
        if($query) {
            $trendsQuery = $trendsQuery->search($query, null, true);
        }
        if($company) {
            $trendsQuery = $trendsQuery->where('company_id', $company);
        }
        $trends = $trendsQuery->paginate(20);
        $companies = Company::pluck('name', 'id');
        return view('backend.trends.index', compact('trends', 'companies'));
    }

    public function create()
    {
        $categories = TrendCategory::pluck('name', 'id');
        $companies = Company::pluck('name', 'id');
        return view('backend.trends.create', compact('categories', 'companies'));
    }

    public function store(Request $request)
    {
        $trend = Trend::create($request->input());
        $trend->slug = str_slug($request->input('name'), '-');
        $trend->save();

        if( $request->hasFile('image') ) {
            $file = $request->file('image');
            $path = 'public/companies/'. $trend->company_id . '/trends/';
            $path = $request->file('image')->storeAs($path, $trend->id . '.' . $file->getClientOriginalExtension());
            $trend->image = $trend->id . '.' . $file->getClientOriginalExtension();
            $trend->save();
        }

        return redirect()->route('backend.trends.show', $trend->id );
    }

    public function show($id)
    {
        $trend = Trend::findOrFail($id);
        return view('backend.trends.show', compact('trend'));
    }

    public function edit($id)
    {
        $categories = TrendCategory::pluck('name', 'id');
        $companies = Company::pluck('name', 'id');
        $trend = Trend::findOrFail($id);
        return view('backend.trends.edit', compact('trend', 'categories', 'companies'));
    }

    public function update(Request $request, $id)
    {
        $trend = Trend::findOrFail($id);
        $trend->fill($request->input());
        $trend->save();

        if( $request->hasFile('image') ) {
            // Delete old file
            $path = 'public/companies/'. $trend->company_id . '/trends/' . $trend->image;
            if(!empty($place->image) && File::exists(storage_path('app/' . $path))) {
                Storage::delete($path);
            }
            // Upload new file
            $file = $request->file('image');
            $path = 'public/companies/'. $trend->company_id . '/trends/';
            $path = $request->file('image')->storeAs($path, $trend->id . '.' . $file->getClientOriginalExtension());
            $trend->image = $trend->id . '.' . $file->getClientOriginalExtension();
            $trend->save();
        }

        return redirect()->route('backend.trends.show', $trend->id );
    }

    public function delete($id)
    {
        $trend = Trend::findOrFail($id);
        $trend->delete();

        return redirect()->route('backend.trends.index');
    }
}
