<?php

namespace App\Http\Controllers\Backend;

use App\Models\Salon;
use App\Models\Country;
use App\Models\Company;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Database\QueryException;

class SalonController extends Controller
{
    public function index(Request $request)
    {
        $query = !empty($request->get('q')) ? $request->get('q') : null;
        $company = !empty($request->get('company')) ? $request->get('company') : null;
        $salonsQuery = Salon::with(['companies', 'country']);

        if($query) {
            $salonsQuery = $salonsQuery->search($query, null, true);
        }
        if($company) {
            $salonsQuery = $salonsQuery->where('company_id', $company);
        }
        $salons = $salonsQuery->paginate(20);
        return view('backend.salons.index', compact('salons', 'companies'));
    }

    public function create()
    {
        $countries = Country::pluck('name_fr', 'id');
        $companies = Company::pluck('name', 'id');
        return view('backend.salons.create', compact('countries', 'companies'));
    }

    public function store(Request $request)
    {
        $salon = Salon::create($request->except('image'));
        $salon->slug = str_slug($request->input('name'), '-');
        $salon->save();

        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $path = 'public/companies/'. $salon->company_id . '/salons/';
            $path = $request->file('image')->storeAs($path, $salon->id . '.' . $file->getClientOriginalExtension());
            $salon->image = $salon->id . '.' . $file->getClientOriginalExtension();
            $salon->save();
        }

        return redirect()->route('backend.salons.show', $salon->id );
    }

    public function show($id)
    {
        $salon = Salon::findOrFail($id);
        return view('backend.salons.show', compact('salon'));
    }

    public function edit($id)
    {
        $countries = Country::pluck('name_fr', 'id');
        $companies = Company::pluck('name', 'id');
        $salon = Salon::findOrFail($id);
        return view('backend.salons.edit', compact('salon', 'countries', 'companies'));
    }

    public function update(Request $request, $id)
    {
        $salon = Salon::findOrFail($id);
        $salon->fill($request->input());
        $salon->save();

        if ($request->hasFile('image')) {
            // Delete old file
            $path = 'public/companies/'. $salon->company_id . '/salons/' . $salon->image;
            if (!empty($product->image) && File::exists(storage_path('app/' . $path))) {
                Storage::delete($path);
            }
            // Upload new file
            $file = $request->file('image');
            $path = 'public/companies/'. $salon->company_id . '/salons/';
            $path = $request->file('image')->storeAs($path, $salon->id . '.' . $file->getClientOriginalExtension());
            $salon->image = $salon->id . '.' . $file->getClientOriginalExtension();
            $salon->save();
        }

        return redirect()->route('backend.salons.show', $salon->id );
    }

    public function delete($id)
    {
        $salon = Salon::find($id);
        $salon->delete();

        return redirect()->route('backend.salons.index');
    }

    public function CompanyCreate($id)
    {
        $salon = Salon::findOrFail($id);
        $companies = Company::pluck('name', 'id');

        return view('backend.salons.companies.create', compact('salon', 'companies'));
    }

    public function CompanyStore(Request $request, $id)
    {
        $salon = Salon::findOrFail($id);
        try{
            $salon->companies()->attach($request->get('company_id'));
        } catch(QueryException $e) {}

        return redirect()->route('backend.salons.show', $salon->id);
    }

    public function CompanyDelete($id, $company_id)
    {
        $salon = Salon::findOrFail($id);
        $salon->companies()->detach($company_id);

        return redirect()->route('backend.salons.show', $salon->id);
    }
}
