<?php

namespace App\Http\Controllers\Backend;

use App\Models\Product;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class CategoryController extends Controller
{
    public function index()
    {
        $categories = Category::where('parent_id', 0)->get();
        return view('backend.categories.index', compact('categories'));
    }

    public function addExisting($cat_id)
    {
        $categories_l0 = Category::with('subs')->where('parent_id', 0)->pluck('name', 'id');
        $category = Category::findOrFail($cat_id);
        return view('backend.categories.add', compact('category', 'categories_l0'));
    }

    public function addExistingPost(Request $request, $cat_id)
    {
        $id_clone = $request->input('id_clone');
        $category = Category::findOrFail($id_clone);
        $newCat = $category->replicate();
        $newCat->copy_id = $id_clone;
        $newCat->parent_id = $cat_id;
        $newCat->save();
        return view('backend.categories.item-new', ['category' => $newCat]);
    }

    public function subCategories($cat_id)
    {
        $categories = Category::where('parent_id', $cat_id)->get();
        $category_selected = Category::findOrFail($cat_id);
        return view('backend.categories.subcat', compact('categories', 'category_selected'));
    }

    public function item($id)
    {
        $category = Category::findOrFail($id);
        return view('backend.categories.item', compact('category'));
    }

    public function store(Request $request)
    {
        $category = Category::create($request->input());
        $category->slug = str_slug($request->input('name'), '-');
        $category->save();
        return view('backend.categories.item-new', compact('category'));
    }

    public function update(Request $request, $id)
    {
        $category = Category::findOrFail($id);
        $category->name = $request->input('name');
        $category->save();

        return response()
            ->json(['status' => true, 'type' => 'success', 'message' => 'Enregistrement mis à jour avec succès', 'id' => $id]);
    }

    public function delete($id)
    {
        $category = Category::findOrFail($id);

        if ($category->level == 2) {
            $produits = Product::where('category_id', $id)->delete();
        } else {
            $categories_childs_ids = Category::childs($id, 2)->pluck('id')->all();
            $categories_childs = Category::childs($id);
            foreach ($categories_childs as $category) {
                $category->delete();
            }
            $produits = Product::whereIN('category_id', $categories_childs_ids)->delete();
        }

        $category->delete();

        return response()
            ->json(['status' => true, 'type' => 'success', 'message' => 'Enregistrements supprimés avec succès', 'id' => $id]);
    }

    public function image($id)
    {
        $category = Category::findOrFail($id);
        return view('backend.categories.image', compact('category'));
    }

    public function imageStore(Request $request, $id)
    {
        $category = Category::findOrFail($id);
        if ($request->input('delete_image') == 1) {
            // Delete old file
            $path = 'public/categories/' . $category->image;
            if (!empty($category->image) && File::exists(storage_path('app/' . $path))) {
                Storage::delete($path);
            }
            $category->image = '';
            $category->save();
        } else if ($request->hasFile('image')) {
            $file = $request->file('image');
            $path = 'public/categories/';
            $path = $request->file('image')->storeAs($path, $category->slug . '.' . $file->getClientOriginalExtension());
            $category->image = $category->slug . '.' . $file->getClientOriginalExtension();
            $category->save();
        }

        return redirect()->route('backend.categories.index');
    }

    public function addOrCopyCat($cat_id)
    {
        return view('backend.categories.addOrCopy');
    }
}
