<?php

namespace App\Http\Controllers\Backend;

use App\Models\Attribute;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Debugbar;

class AttributeController extends Controller
{
    public function index($id = null)
    {
        $category = ($id != null) ? Category::level(2)->with(['parent', 'parent.parent'])->findOrFail($id) : null;
        // $categories = Category::with(['parent', 'parent.parent'])->where('level', 2)->get();
        $categories = Category::with('subs')->where('parent_id', 0)->get();
        $attributes = Attribute::with('childs')->where('category_id', $id)->whereNull('parent_id')->get();
        return view('backend.attributes.index', compact('attributes', 'categories', 'category'));
    }

    public function create($id)
    {
        $category = Category::level(2)->with(['parent', 'parent.parent'])->findOrFail($id);
        return view('backend.attributes.create', compact('category'));
    }

    public function store(Request $request, $id)
    {
        if ($request->input('type') == 'interval') {
            $default_value = $request->input('default_value_min') . ':' . $request->input('default_value_max');
        } else {
            $default_value = $request->input('default_value');
        }
        $attribute = Attribute::create([
            'category_id'   => $id,
            'name'          => $request->input('name'),
            'type'          => $request->input('type'),
            'default_value' => $default_value,
            'value'         => $request->input('value'),
            'multi_value'   => $request->input('multi_value'),
            'required'      => $request->input('required'),
            'filtrable'     => $request->input('filtrable'),
            'unite'         => $request->input('unite'),
        ]);


        return redirect()->back();
    }

    public function edit($id)
    {
        $attribute = Attribute::findOrFail($id);

        return view('backend.attributes.edit', compact('attribute'));
    }

    public function update(Request $request, $id)
    {
        $attribute = Attribute::findOrFail($id);
        if ($request->input('type') == 'interval') {
            $default_value = $request->input('default_value_min') . ':' . $request->input('default_value_max');
        } else {
            $default_value = $request->input('default_value');
        }
        $attribute->fill([
            'name'          => $request->input('name'),
            'type'          => $request->input('type'),
            'default_value' => $default_value,
            'value'         => $request->input('value'),
            'multi_value'   => $request->input('multi_value'),
            'required'      => $request->input('required'),
            'filtrable'     => $request->input('filtrable'),
            'unite'         => $request->input('unite'),
        ]);
        $attribute->save();

        return redirect()->back();
    }

    public function delete($id)
    {
        $attribute = Attribute::findOrFail($id);
        $attribute->delete();

        return redirect()->back();
    }


    public function createSub($id_category, $id_parent)
    {
        $category = Category::level(2)->with(['parent', 'parent.parent'])->findOrFail($id_category);
        $attribute_parent = Attribute::findOrFail($id_parent);
        return view('backend.attributes.create_sub', compact('category', 'attribute_parent'));
    }


    public function storeSub(Request $request, $id_category, $id_parent)
    {
        if ($request->input('type') == 'interval') {
            $default_value = $request->input('default_value_min') . ':' . $request->input('default_value_max');
        } else {
            $default_value = $request->input('default_value');
        }
        $attribute = Attribute::create([
            'category_id'   => $id_category,
            'name'          => $request->input('name'),
            'type'          => $request->input('type'),
            'type'          => $request->input('type'),
            'default_value' => $default_value,
            'value'         => $request->input('value'),
            'multi_value'   => $request->input('multi_value'),
            'required'      => $request->input('required'),
            'filtrable'     => $request->input('filtrable'),
            'unite'         => $request->input('unite'),
            'parent_id'     => $id_parent,
            'parent_value'  => $request->input('parent_value'),
        ]);

        return redirect()->back();
    }
}
